/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.Repository;
import org.pitest.functional.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestToClassMapper {
    private static final int TEST_LENGTH = "Test".length();
    private final Repository repository;

    public TestToClassMapper(Repository repository) {
        this.repository = repository;
    }

    public Option<ClassName> findTestee(String className) {
        ClassName name = new ClassName(className);
        if (name.asJavaName().endsWith("Test") && this.tryName(name.withoutSuffixChars(TEST_LENGTH))) {
            return Option.some(name.withoutSuffixChars(TEST_LENGTH));
        }
        if (name.getNameWithoutPackage().asJavaName().startsWith("Test") && this.tryName(name.withoutPrefixChars(TEST_LENGTH))) {
            return Option.some(name.withoutPrefixChars(TEST_LENGTH));
        }
        return Option.none();
    }

    private boolean tryName(ClassName name) {
        return this.repository.hasClass(name);
    }
}

