/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.functional.Option;
import org.pitest.util.StreamUtil;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveClassPathRoot
implements ClassPathRoot {
    private final File file;

    public ArchiveClassPathRoot(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getData(String name) throws IOException {
        ZipFile zip = this.getRoot();
        try {
            ZipEntry entry = zip.getEntry(name.replace('.', '/') + ".class");
            if (entry == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = StreamUtil.copyStream(zip.getInputStream(entry));
            return inputStream;
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) throws MalformedURLException {
        ZipFile zip = this.getRoot();
        try {
            ZipEntry entry = zip.getEntry(name);
            if (entry != null) {
                URL uRL = new URL("jar:file:" + zip.getName() + "!/" + entry.getName());
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            this.closeQuietly(zip);
        }
    }

    private void closeQuietly(ZipFile zip) {
        try {
            zip.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public String toString() {
        return "ArchiveClassPathRoot [file=" + this.file.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> classNames() {
        ArrayList<String> names = new ArrayList<String>();
        ZipFile root = this.getRoot();
        try {
            Enumeration<? extends ZipEntry> entries = root.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                names.add(this.stringToClassName(entry.getName()));
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            this.closeQuietly(root);
        }
    }

    private String stringToClassName(String name) {
        return name.substring(0, name.length() - ".class".length()).replace('/', '.');
    }

    @Override
    public Option<String> cacheLocation() {
        return Option.some(this.file.getAbsolutePath());
    }

    private ZipFile getRoot() {
        try {
            return new ZipFile(this.file);
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex.getMessage() + " (" + this.file + ")", ex);
        }
    }
}

