/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.pitest.classpath.ArchiveClassPathRoot;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.CompoundClassPathRoot;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.util.Log;
import org.pitest.util.PitError;
import org.pitest.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPath {
    private static final Logger LOG = Log.getLogger();
    private final CompoundClassPathRoot root;

    public ClassPath() {
        this(ClassPath.getClassPathElementsAsFiles());
    }

    public ClassPath(ClassPathRoot ... roots) {
        this(Arrays.asList(roots));
    }

    public ClassPath(List<ClassPathRoot> roots) {
        this.root = new CompoundClassPathRoot(roots);
    }

    public ClassPath(Collection<File> files) {
        this(ClassPath.createRoots(FCollection.filter(files, ClassPath.exists())));
    }

    private static F<File, Boolean> exists() {
        return new F<File, Boolean>(){

            @Override
            public Boolean apply(File a) {
                return a.exists() && a.canRead();
            }
        };
    }

    public Collection<String> classNames() {
        return this.root.classNames();
    }

    private static List<ClassPathRoot> createRoots(Collection<File> files) {
        File lastFile = null;
        try {
            ArrayList<ClassPathRoot> rs = new ArrayList<ClassPathRoot>();
            Iterator<File> i$ = files.iterator();
            while (i$.hasNext()) {
                File f;
                lastFile = f = i$.next();
                if (f.isDirectory()) {
                    rs.add(new DirectoryClassPathRoot(f));
                    continue;
                }
                try {
                    if (!f.canRead()) {
                        throw new IOException("Can't read the file " + f);
                    }
                    rs.add(new ArchiveClassPathRoot(f));
                }
                catch (ZipException ex) {
                    LOG.warning("Can't open the archive " + f);
                }
            }
            return rs;
        }
        catch (IOException ex) {
            throw new PitError("Error handling file " + lastFile, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassData(String classname) throws IOException {
        InputStream is = this.root.getData(classname);
        if (is != null) {
            try {
                byte[] byArray = StreamUtil.streamToByteArray(is);
                return byArray;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    public URL findResource(String name) {
        try {
            return this.root.getResource(name);
        }
        catch (IOException exception) {
            return null;
        }
    }

    public static Collection<File> getClassPathElementsAsFiles() {
        String[] elements = ClassPath.getClassPathElements();
        LinkedHashSet<File> us = new LinkedHashSet<File>();
        for (String each : elements) {
            us.add(new File(each));
        }
        return us;
    }

    public static String[] getClassPathElements() {
        String classPath = System.getProperty("java.class.path");
        String separator = File.pathSeparator;
        if (classPath != null) {
            return classPath.split(separator);
        }
        return new String[0];
    }

    public Collection<String> findClasses(Predicate<String> nameFilter) {
        return FCollection.filter(this.classNames(), nameFilter);
    }

    public String getLocalClassPath() {
        return this.root.cacheLocation().value();
    }

    public ClassPath getComponent(Predicate<ClassPathRoot> predicate) {
        return new ClassPath(FCollection.filter(this.root, predicate).toArray((ClassPathRoot[])new ClassPathRoot[0]));
    }

    public CompoundClassPathRoot asRoot() {
        return this.root;
    }
}

