/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassInfoSource;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.NameToClassInfo;
import org.pitest.classinfo.Repository;
import org.pitest.classinfo.TestToClassMapper;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.functional.prelude.Prelude;
import org.pitest.testapi.TestClassIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSource
implements ClassInfoSource {
    private final ProjectClassPaths classPath;
    private final Repository classRepository;
    private final TestClassIdentifier testIdentifier;

    public CodeSource(ProjectClassPaths classPath, TestClassIdentifier testIdentifier) {
        this(classPath, new Repository(new ClassPathByteArraySource(classPath.getClassPath())), testIdentifier);
    }

    CodeSource(ProjectClassPaths classPath, Repository classRepository, TestClassIdentifier testIdentifier) {
        this.classPath = classPath;
        this.classRepository = classRepository;
        this.testIdentifier = testIdentifier;
    }

    public Collection<ClassInfo> getCode() {
        return FCollection.flatMap(this.classPath.code(), this.nameToClassInfo()).filter(Prelude.not(this.isWithinATestClass()));
    }

    public Set<ClassName> getCodeUnderTestNames() {
        HashSet<ClassName> codeClasses = new HashSet<ClassName>();
        FCollection.mapTo(this.getCode(), ClassInfo.toClassName(), codeClasses);
        return codeClasses;
    }

    public List<ClassInfo> getTests() {
        return FCollection.flatMap(this.classPath.test(), this.nameToClassInfo()).filter(Prelude.and(this.isWithinATestClass(), this.isIncludedClass(), Prelude.not(ClassInfo.matchIfAbstract())));
    }

    public ClassPath getClassPath() {
        return this.classPath.getClassPath();
    }

    public ProjectClassPaths getProjectPaths() {
        return this.classPath;
    }

    public Option<ClassName> findTestee(String className) {
        TestToClassMapper mapper = new TestToClassMapper(this.classRepository);
        return mapper.findTestee(className);
    }

    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return FCollection.flatMap(classes, this.nameToClassInfo());
    }

    @Override
    public Option<ClassInfo> fetchClass(ClassName clazz) {
        return this.classRepository.fetchClass(clazz);
    }

    private F<ClassName, Option<ClassInfo>> nameToClassInfo() {
        return new NameToClassInfo(this.classRepository);
    }

    private F<ClassInfo, Boolean> isWithinATestClass() {
        return new F<ClassInfo, Boolean>(){

            @Override
            public Boolean apply(ClassInfo a) {
                return CodeSource.this.testIdentifier.isATestClass(a);
            }
        };
    }

    private F<ClassInfo, Boolean> isIncludedClass() {
        return new F<ClassInfo, Boolean>(){

            @Override
            public Boolean apply(ClassInfo a) {
                return CodeSource.this.testIdentifier.isIncluded(a);
            }
        };
    }
}

