/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.functional.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryClassPathRoot
implements ClassPathRoot {
    private final File root;

    public DirectoryClassPathRoot(File root) {
        this.root = root;
    }

    @Override
    public InputStream getData(String classname) throws IOException {
        String filename = classname.replace('.', File.separatorChar).concat(".class");
        File file = new File(this.root, filename);
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public URL getResource(String name) throws MalformedURLException {
        File f = new File(this.root, name);
        if (f.canRead()) {
            return f.toURI().toURL();
        }
        return null;
    }

    @Override
    public Collection<String> classNames() {
        return this.classNames(this.root);
    }

    private Collection<String> classNames(File file) {
        LinkedList<String> classNames = new LinkedList<String>();
        for (File f : file.listFiles()) {
            if (f.isDirectory()) {
                classNames.addAll(this.classNames(f));
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            classNames.add(this.fileToClassName(f));
        }
        return classNames;
    }

    private String fileToClassName(File f) {
        return f.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1, f.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.');
    }

    @Override
    public Option<String> cacheLocation() {
        return Option.some(this.root.getAbsolutePath());
    }
}

