/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.ClassStatistics;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.CoverageSummary;
import org.pitest.coverage.LineCoverage;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.testapi.Description;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageData
implements CoverageDatabase {
    private static final Logger LOG = Log.getLogger();
    private final Map<ClassName, Map<ClassLine, Set<TestInfo>>> classCoverage = new LinkedHashMap<ClassName, Map<ClassLine, Set<TestInfo>>>();
    private final CodeSource code;
    private boolean hasFailedTest = false;

    public CoverageData(CodeSource code) {
        this.code = code;
    }

    @Override
    public Collection<TestInfo> getTestsForClassLine(ClassLine classLine) {
        Collection result = this.getTestsForClassName(classLine.getClassName()).get(classLine);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public boolean allTestsGreen() {
        return !this.hasFailedTest;
    }

    @Override
    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return this.code.getClassInfo(classes);
    }

    @Override
    public int getNumberOfCoveredLines(Collection<ClassName> mutatedClass) {
        return FCollection.fold(this.numberCoveredLines(), 0, mutatedClass);
    }

    @Override
    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.getTestsForClassName(clazz);
        LinkedHashSet<TestInfo> tis = new LinkedHashSet<TestInfo>(map.values().size());
        for (Set<TestInfo> each : map.values()) {
            tis.addAll(each);
        }
        return tis;
    }

    public void calculateClassCoverage(CoverageResult cr) {
        this.checkForFailedTest(cr);
        TestInfo ti = this.createTestInfo(cr.getTestUnitDescription(), cr.getExecutionTime(), cr.getNumberOfCoveredLines());
        for (ClassStatistics i : cr.getCoverage()) {
            Map<ClassLine, Set<TestInfo>> map = this.getCoverageMapForClass(i.getClassName());
            this.mapTestsToClassLines(ti, i, map);
        }
    }

    private void checkForFailedTest(CoverageResult cr) {
        if (!cr.isGreenTest()) {
            this.recordTestFailure();
            LOG.warning(cr.getTestUnitDescription() + " did not pass without mutation.");
        }
    }

    private void mapTestsToClassLines(TestInfo test, ClassStatistics stats, Map<ClassLine, Set<TestInfo>> map) {
        for (int line : stats.getUniqueVisitedLines()) {
            ClassLine key = new ClassLine(stats.getClassName(), line);
            Set<TestInfo> testsForLine = map.get(key);
            if (testsForLine == null) {
                testsForLine = new TreeSet<TestInfo>(new TestInfoNameComparator());
                map.put(key, testsForLine);
            }
            testsForLine.add(test);
        }
    }

    private TestInfo createTestInfo(Description description, int executionTime, int linesCovered) {
        Option<ClassName> testee = this.code.findTestee(description.getFirstTestClass());
        return new TestInfo(description.getFirstTestClass(), description.getQualifiedName(), executionTime, testee, linesCovered);
    }

    private F2<Integer, ClassName, Integer> numberCoveredLines() {
        return new F2<Integer, ClassName, Integer>(){

            @Override
            public Integer apply(Integer a, ClassName clazz) {
                return a + CoverageData.this.getNumberOfCoveredLines(clazz);
            }
        };
    }

    private int getNumberOfCoveredLines(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.classCoverage.get(clazz);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private Map<ClassLine, Set<TestInfo>> getTestsForClassName(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.classCoverage.get(clazz);
        if (map == null) {
            map = new LinkedHashMap<ClassLine, Set<TestInfo>>(0);
        }
        return map;
    }

    private void recordTestFailure() {
        this.hasFailedTest = true;
    }

    private Map<ClassLine, Set<TestInfo>> getCoverageMapForClass(ClassName className) {
        Map<ClassLine, Set<TestInfo>> map = this.classCoverage.get(className);
        if (map == null) {
            map = new LinkedHashMap<ClassLine, Set<TestInfo>>(0);
            this.classCoverage.put(className, map);
        }
        return map;
    }

    @Override
    public BigInteger getCoverageIdForClass(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> coverage = this.classCoverage.get(clazz);
        if (coverage == null) {
            return BigInteger.ZERO;
        }
        return this.generateCoverageNumber(coverage);
    }

    public List<LineCoverage> createLineCoverage() {
        return FCollection.flatMap(this.classCoverage.values(), this.toLineCoverage());
    }

    private F<Map<ClassLine, Set<TestInfo>>, Collection<LineCoverage>> toLineCoverage() {
        return new F<Map<ClassLine, Set<TestInfo>>, Collection<LineCoverage>>(){

            @Override
            public Collection<LineCoverage> apply(Map<ClassLine, Set<TestInfo>> a) {
                return FCollection.map(a.entrySet(), CoverageData.this.entryToLineCoverage());
            }
        };
    }

    private F<Map.Entry<ClassLine, Set<TestInfo>>, LineCoverage> entryToLineCoverage() {
        return new F<Map.Entry<ClassLine, Set<TestInfo>>, LineCoverage>(){

            @Override
            public LineCoverage apply(Map.Entry<ClassLine, Set<TestInfo>> a) {
                return new LineCoverage(a.getKey(), FCollection.map((Iterable)a.getValue(), TestInfo.toName()));
            }
        };
    }

    private BigInteger generateCoverageNumber(Map<ClassLine, Set<TestInfo>> coverage) {
        BigInteger coverageNumber = BigInteger.ZERO;
        HashSet<ClassName> testClasses = new HashSet<ClassName>();
        FCollection.flatMapTo(coverage.values(), this.testsToClassName(), testClasses);
        for (ClassInfo each : this.code.getClassInfo(testClasses)) {
            coverageNumber = coverageNumber.add(each.getDeepHash());
        }
        return coverageNumber;
    }

    private F<Set<TestInfo>, Iterable<ClassName>> testsToClassName() {
        return new F<Set<TestInfo>, Iterable<ClassName>>(){

            @Override
            public Iterable<ClassName> apply(Set<TestInfo> a) {
                return FCollection.map(a, TestInfo.toDefiningClassName());
            }
        };
    }

    @Override
    public Collection<ClassInfo> getClassesForFile(String sourceFile, String packageName) {
        return FCollection.filter(this.code.getCode(), CoverageData.matchesSourceAndPackage(sourceFile, packageName));
    }

    private static F<ClassInfo, Boolean> matchesSourceAndPackage(final String sourceFile, final String packageName) {
        return new F<ClassInfo, Boolean>(){

            @Override
            public Boolean apply(ClassInfo a) {
                return a.getSourceFileName().equals(sourceFile) && a.getName().getPackage().asJavaName().equals(packageName);
            }
        };
    }

    @Override
    public CoverageSummary createSummary() {
        return new CoverageSummary(this.numberOfLines(), this.coveredLines());
    }

    private int numberOfLines() {
        return FCollection.fold(this.numberLines(), 0, this.code.getClassInfo(this.classCoverage.keySet()));
    }

    private int coveredLines() {
        return FCollection.fold(this.numberCoveredLines(), 0, this.classCoverage.keySet());
    }

    private F2<Integer, ClassInfo, Integer> numberLines() {
        return new F2<Integer, ClassInfo, Integer>(){

            @Override
            public Integer apply(Integer a, ClassInfo clazz) {
                return a + clazz.getNumberOfCodeLines();
            }
        };
    }
}

