/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.io.Serializable;
import java.util.Collection;
import org.pitest.coverage.ClassStatistics;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.testapi.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Description testUnitDescription;
    private final int executionTime;
    private final Collection<ClassStatistics> coverage;
    private final boolean greenSuite;

    public CoverageResult(Description testUnitDescription, int executionTime, boolean greenSuite, Collection<ClassStatistics> coverage) {
        this.testUnitDescription = testUnitDescription;
        this.executionTime = executionTime;
        this.coverage = coverage;
        this.greenSuite = greenSuite;
    }

    public Description getTestUnitDescription() {
        return this.testUnitDescription;
    }

    public int getExecutionTime() {
        return this.executionTime;
    }

    public Collection<ClassStatistics> getCoverage() {
        return this.coverage;
    }

    public boolean isGreenTest() {
        return this.greenSuite;
    }

    public int getNumberOfCoveredLines() {
        return FCollection.fold(CoverageResult.classStatisticsToLineCount(), 0, this.coverage);
    }

    private static F2<Integer, ClassStatistics, Integer> classStatisticsToLineCount() {
        return new F2<Integer, ClassStatistics, Integer>(){

            @Override
            public Integer apply(Integer a, ClassStatistics b) {
                return a + b.getUniqueVisitedLines().size();
            }
        };
    }

    public String toString() {
        return "CoverageResult [testUnitDescription=" + this.testUnitDescription + ", executionTime=" + this.executionTime + ", coverage=" + this.coverage + ", greenSuite=" + this.greenSuite + "]";
    }
}

