/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInfo {
    private final String name;
    private final String definingClass;
    private final int time;
    private final int linesCovered;
    private final Option<ClassName> testee;

    public TestInfo(String definingClass, String name, int time, Option<ClassName> testee, int linesCovered) {
        this.definingClass = this.internIfNotNull(definingClass);
        this.name = name;
        this.time = time;
        this.testee = testee;
        this.linesCovered = linesCovered;
    }

    private String internIfNotNull(String string) {
        if (string == null) {
            return null;
        }
        return string.intern();
    }

    public String getName() {
        return this.name;
    }

    public int getTime() {
        return this.time;
    }

    public int getNumberOfLinesCovered() {
        return this.linesCovered;
    }

    public String toString() {
        return this.name;
    }

    public static F<TestInfo, String> toName() {
        return new F<TestInfo, String>(){

            @Override
            public String apply(TestInfo a) {
                return a.getName();
            }
        };
    }

    public static F<TestInfo, ClassName> toDefiningClassName() {
        return new F<TestInfo, ClassName>(){

            @Override
            public ClassName apply(TestInfo a) {
                return new ClassName(a.definingClass);
            }
        };
    }

    public boolean directlyHits(ClassName targetClass) {
        return this.testee.hasSome() && this.testee.value().equals(targetClass);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definingClass == null ? 0 : this.definingClass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestInfo other = (TestInfo)obj;
        if (this.definingClass == null ? other.definingClass != null : !this.definingClass.equals(other.definingClass)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

