/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.codeassist;

import org.pitest.coverage.codeassist.CoverageMethodVisitor;
import org.pitest.coverage.codeassist.LineTracker;
import org.pitest.coverage.codeassist.LocalVariableCoverageMethodVisitor;
import org.pitest.coverage.codeassist.SimpleCoverageVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.tree.AbstractInsnNode;
import org.pitest.reloc.asm.tree.LineNumberNode;
import org.pitest.reloc.asm.tree.MethodNode;

public class CoverageAnalyser
extends MethodNode {
    private static final int MAX_SUPPORTED_LOCAL_PROBES = 15;
    private final LineTracker lineTracker;
    private final int classId;
    private final MethodVisitor mv;
    private final int probeOffset;

    public CoverageAnalyser(LineTracker lineTracker, int classId, int probeOffset, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(327680, access, name, desc, signature, exceptions);
        this.mv = mv;
        this.lineTracker = lineTracker;
        this.classId = classId;
        this.probeOffset = probeOffset;
    }

    public void visitEnd() {
        int numberOfProbes = this.countRequiredProbes();
        if (numberOfProbes == 1 || this.name.equals("<init>")) {
            this.accept(new SimpleCoverageVisitor(this.lineTracker, this.classId, this.mv, this.access, this.name, this.desc, this.probeOffset));
        } else if (numberOfProbes <= 15 && numberOfProbes >= 1) {
            this.accept(new LocalVariableCoverageMethodVisitor(this.lineTracker, this.classId, this.mv, this.access, this.name, this.desc, numberOfProbes, this.probeOffset));
        } else {
            this.accept(new CoverageMethodVisitor(this.lineTracker, this.classId, this.mv, this.access, this.name, this.desc, numberOfProbes, this.probeOffset));
        }
    }

    private int countRequiredProbes() {
        int count = 0;
        for (int i = 0; i < this.instructions.size(); ++i) {
            AbstractInsnNode ins = this.instructions.get(i);
            if (!(ins instanceof LineNumberNode)) continue;
            ++count;
        }
        return count;
    }
}

