/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pitest.coverage.codeassist.BridgeMethodFilter;
import org.pitest.coverage.codeassist.CoverageAnalyser;
import org.pitest.coverage.codeassist.LineTracker;
import org.pitest.coverage.codeassist.MethodFilteringAdapter;
import org.pitest.reloc.asm.ClassWriter;
import org.pitest.reloc.asm.MethodVisitor;
import sun.pitest.CodeCoverageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageClassVisitor
extends MethodFilteringAdapter
implements LineTracker {
    private final int classId;
    private final List<Integer> probesToLines = new ArrayList<Integer>();

    public CoverageClassVisitor(int classId, ClassWriter writer) {
        super(writer, BridgeMethodFilter.INSTANCE);
        this.classId = classId;
    }

    @Override
    public void registerLine(int line) {
        this.probesToLines.add(line);
    }

    @Override
    public MethodVisitor visitMethodIfRequired(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor methodVisitor) {
        return new CoverageAnalyser(this, this.classId, this.probesToLines.size(), methodVisitor, access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        CodeCoverageStore.registerClassProbes(this.classId, CoverageClassVisitor.convertToPrimitiveArray(this.probesToLines));
    }

    public static int[] convertToPrimitiveArray(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }
}

