/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.codeassist;

import org.pitest.coverage.codeassist.LineTracker;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.AdviceAdapter;
import sun.pitest.CodeCoverageStore;

public class CoverageMethodVisitor
extends AdviceAdapter {
    private final MethodVisitor methodVisitor;
    private final int classId;
    private final int numberOfProbes;
    private final LineTracker lineTracker;
    private final int probeOffset;
    private final Label before = new Label();
    private final Label handler = new Label();
    private int probeCount = 0;
    private int probeHitArrayLocal;

    public CoverageMethodVisitor(LineTracker lineTracker, int classId, MethodVisitor writer, int access, String name, String desc, int numberOfLines, int probeOffset) {
        super(327680, writer, access, name, desc);
        this.methodVisitor = writer;
        this.classId = classId;
        this.lineTracker = lineTracker;
        this.numberOfProbes = numberOfLines;
        this.probeOffset = probeOffset;
    }

    public void visitCode() {
        super.visitCode();
        this.probeHitArrayLocal = this.newLocal(Type.getType("[Z"));
        this.pushConstant(this.numberOfProbes);
        this.mv.visitIntInsn(188, 4);
        this.mv.visitVarInsn(58, this.probeHitArrayLocal);
        this.mv.visitLabel(this.before);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitTryCatchBlock(this.before, this.handler, this.handler, null);
        this.mv.visitLabel(this.handler);
        this.generateProbeReportCode();
        this.mv.visitInsn(191);
        this.mv.visitMaxs(0, 0);
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.generateProbeReportCode();
        }
    }

    private void generateProbeReportCode() {
        this.pushConstant(this.classId);
        this.pushConstant(this.probeOffset);
        this.mv.visitVarInsn(25, this.probeHitArrayLocal);
        this.methodVisitor.visitMethodInsn(184, CodeCoverageStore.CLASS_NAME, "visitProbes", "(II[Z)V", false);
    }

    public void visitLineNumber(int line, Label start) {
        this.lineTracker.registerLine(line);
        this.mv.visitVarInsn(25, this.probeHitArrayLocal);
        this.pushConstant(this.probeCount);
        this.pushConstant(1);
        this.mv.visitInsn(84);
        ++this.probeCount;
        this.methodVisitor.visitLineNumber(line, start);
    }

    private void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (value <= 127) {
                    this.mv.visitIntInsn(16, value);
                    break;
                }
                if (value <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, value);
                    break;
                }
                this.mv.visitLdcInsn(value);
            }
        }
    }
}

