/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.coverage.CoverageTransformer;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.CoveragePipe;
import org.pitest.coverage.execute.CoverageWorker;
import org.pitest.coverage.execute.DependencyFilter;
import org.pitest.dependency.DependencyExtractor;
import org.pitest.execute.Pitest;
import org.pitest.execute.UnGroupedStrategy;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.testapi.TestUnit;
import org.pitest.util.ExitCode;
import org.pitest.util.Functions;
import org.pitest.util.Log;
import org.pitest.util.SafeDataInputStream;
import org.pitest.util.Unchecked;
import sun.pitest.CodeCoverageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageSlave {
    private static final Logger LOG = Log.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExitCode exitCode = ExitCode.OK;
        Socket s = null;
        CoveragePipe invokeQueue = null;
        try {
            int port = Integer.valueOf(args[0]);
            s = new Socket("localhost", port);
            SafeDataInputStream dis = new SafeDataInputStream(s.getInputStream());
            CoverageOptions paramsFromParent = dis.read(CoverageOptions.class);
            Log.setVerbose(paramsFromParent.isVerbose());
            if (paramsFromParent.getPitConfig().verifyEnvironment().hasSome()) {
                throw paramsFromParent.getPitConfig().verifyEnvironment().value();
            }
            invokeQueue = new CoveragePipe(new BufferedOutputStream(s.getOutputStream()));
            CodeCoverageStore.init(invokeQueue);
            HotSwapAgent.addTransformer(new CoverageTransformer(CoverageSlave.convertToJVMClassFilter(paramsFromParent.getFilter())));
            List<TestUnit> tus = CoverageSlave.getTestsFromParent(dis, paramsFromParent);
            LOG.info(tus.size() + " tests received");
            CoverageWorker worker = new CoverageWorker(invokeQueue, tus);
            worker.run();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Error calculating coverage. Process will exit.", ex);
            exitCode = ExitCode.UNKNOWN_ERROR;
        }
        finally {
            if (invokeQueue != null) {
                invokeQueue.end(exitCode);
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException(e);
            }
        }
        System.exit(exitCode.getCode());
    }

    private static Predicate<String> convertToJVMClassFilter(final Predicate<String> child) {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return (Boolean)child.apply(a.replace("/", "."));
            }
        };
    }

    private static List<TestUnit> getTestsFromParent(SafeDataInputStream dis, CoverageOptions paramsFromParent) throws IOException {
        List<ClassName> classes = CoverageSlave.receiveTestClassesFromParent(dis);
        Collections.sort(classes);
        List<TestUnit> tus = CoverageSlave.discoverTests(paramsFromParent, classes);
        DependencyFilter filter = new DependencyFilter(new DependencyExtractor(new ClassPathByteArraySource(), paramsFromParent.getDependencyAnalysisMaxDistance()), paramsFromParent.getFilter());
        List<TestUnit> filteredTus = filter.filterTestsByDependencyAnalysis(tus);
        LOG.info("Dependency analysis reduced number of potential tests by " + (tus.size() - filteredTus.size()));
        return filteredTus;
    }

    private static List<TestUnit> discoverTests(CoverageOptions paramsFromParent, List<ClassName> classes) {
        List<TestUnit> tus = Pitest.findTestUnitsForAllSuppliedClasses(paramsFromParent.getPitConfig(), new UnGroupedStrategy(), FCollection.flatMap(classes, Functions.nameToClass()));
        LOG.info("Found  " + tus.size() + " tests");
        return tus;
    }

    private static List<ClassName> receiveTestClassesFromParent(SafeDataInputStream dis) {
        int count = dis.readInt();
        LOG.fine("Expecting " + count + " tests classes from parent");
        ArrayList<ClassName> classes = new ArrayList<ClassName>(count);
        for (int i = 0; i != count; ++i) {
            classes.add(new ClassName(dis.readString()));
        }
        LOG.fine("Tests classes received");
        return classes;
    }
}

