/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pitest.coverage.CoverageReceiver;
import org.pitest.coverage.execute.CoverageDecorator;
import org.pitest.coverage.execute.CoveragePipe;
import org.pitest.coverage.execute.ErrorListener;
import org.pitest.execute.DefaultStaticConfig;
import org.pitest.execute.Pitest;
import org.pitest.execute.containers.UnContainer;
import org.pitest.testapi.TestUnit;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageWorker
implements Runnable {
    private final CoveragePipe pipe;
    private final List<TestUnit> tests;

    public CoverageWorker(CoveragePipe pipe, List<TestUnit> tests) {
        this.pipe = pipe;
        this.tests = tests;
    }

    @Override
    public void run() {
        try {
            List<TestUnit> decoratedTests = this.decorateForCoverage(this.tests, this.pipe);
            Collections.sort(decoratedTests, this.testComparator());
            UnContainer c = new UnContainer();
            DefaultStaticConfig staticConfig = new DefaultStaticConfig();
            staticConfig.addTestListener(new ErrorListener());
            Pitest pit = new Pitest(staticConfig);
            pit.run(c, decoratedTests);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private Comparator<TestUnit> testComparator() {
        return new Comparator<TestUnit>(){

            @Override
            public int compare(TestUnit o1, TestUnit o2) {
                return o1.getDescription().getQualifiedName().compareTo(o2.getDescription().getQualifiedName());
            }
        };
    }

    private List<TestUnit> decorateForCoverage(List<TestUnit> plainTests, CoverageReceiver queue) {
        ArrayList<TestUnit> decorated = new ArrayList<TestUnit>(plainTests.size());
        for (TestUnit each : plainTests) {
            decorated.add(new CoverageDecorator(queue, each));
        }
        return decorated;
    }
}

