/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.coverage.ClassStatistics;
import org.pitest.coverage.CoverageResult;
import org.pitest.functional.SideEffect1;
import org.pitest.testapi.Description;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataInputStream;
import sun.pitest.CodeCoverageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Receive
implements ReceiveStrategy {
    private final Map<Integer, String> classIdToName = new ConcurrentHashMap<Integer, String>();
    private final SideEffect1<CoverageResult> handler;

    Receive(SideEffect1<CoverageResult> handler) {
        this.handler = handler;
    }

    @Override
    public void apply(byte control, SafeDataInputStream is) {
        switch (control) {
            case 32: {
                int id = is.readInt();
                String name = is.readString();
                this.classIdToName.put(id, name);
                break;
            }
            case 16: {
                this.handleTestEnd(is);
                break;
            }
        }
    }

    private void handleTestEnd(SafeDataInputStream is) {
        Description d = is.read(Description.class);
        long numberOfResults = is.readLong();
        HashMap<Integer, ClassStatistics> hits = new HashMap<Integer, ClassStatistics>();
        int i = 0;
        while ((long)i != numberOfResults) {
            this.readLineHit(is, hits);
            ++i;
        }
        this.handler.apply(this.createCoverageResult(is, d, hits));
    }

    private void readLineHit(SafeDataInputStream is, Map<Integer, ClassStatistics> hits) {
        long encoded = is.readLong();
        int classId = CodeCoverageStore.decodeClassId(encoded);
        int lineNumber = CodeCoverageStore.decodeLineId(encoded);
        ClassStatistics stats = this.getStatisticsForClass(hits, classId);
        stats.registerLineVisit(lineNumber);
    }

    private CoverageResult createCoverageResult(SafeDataInputStream is, Description d, Map<Integer, ClassStatistics> hits) {
        boolean isGreen = is.readBoolean();
        int executionTime = is.readInt();
        CoverageResult cr = new CoverageResult(d, executionTime, isGreen, hits.values());
        return cr;
    }

    private ClassStatistics getStatisticsForClass(Map<Integer, ClassStatistics> hits, int classId) {
        ClassStatistics stats = hits.get(classId);
        if (stats == null) {
            stats = new ClassStatistics(this.classIdToName.get(classId));
            hits.put(classId, stats);
        }
        return stats;
    }
}

