/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.export;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pitest.coverage.CoverageExporter;
import org.pitest.coverage.LineCoverage;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCoverageExporter
implements CoverageExporter {
    private final ResultOutputStrategy outputStrategy;

    public DefaultCoverageExporter(ResultOutputStrategy outputStrategy) {
        this.outputStrategy = outputStrategy;
    }

    @Override
    public void recordCoverage(Collection<LineCoverage> coverage) {
        Writer out = this.outputStrategy.createWriterForFile("linecoverage.xml");
        this.writeHeader(out);
        for (LineCoverage each : coverage) {
            this.writeLineCoverage(each, out);
        }
        this.writeFooterAndClose(out);
    }

    private void writeHeader(Writer out) {
        this.write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(out, "<coverage>\n");
    }

    private void writeLineCoverage(LineCoverage each, Writer out) {
        this.write(out, "<line classname='" + each.getClassLine().getClassName().asJavaName() + "'" + " number='" + each.getClassLine().getLineNumber() + "'>");
        this.write(out, "<tests>\n");
        ArrayList<String> ts = new ArrayList<String>(each.getTests());
        Collections.sort(ts);
        for (String test : ts) {
            this.write(out, "<test name='" + test + "'/>\n");
        }
        this.write(out, "</tests>\n");
        this.write(out, "</line>\n");
    }

    private void writeFooterAndClose(Writer out) {
        try {
            this.write(out, "</coverage>\n");
            out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private void write(Writer out, String value) {
        try {
            out.write(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }
}

