/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.execute;

import java.util.LinkedHashSet;
import java.util.Set;
import org.pitest.execute.ResultClassifier;
import org.pitest.execute.ResultType;
import org.pitest.testapi.TestResult;
import org.pitest.util.PitError;

public class DefaultResultClassifier
implements ResultClassifier {
    private final Set<String> assertionTypes = new LinkedHashSet<String>();

    public DefaultResultClassifier() {
        this.assertionTypes.add("java.lang.AssertionError");
        this.assertionTypes.add("junit.framework.AssertionFailedError");
    }

    public ResultType classify(TestResult result) {
        switch (result.getState()) {
            case STARTED: {
                return ResultType.STARTED;
            }
            case NOT_RUN: {
                return ResultType.SKIPPED;
            }
            case FINISHED: {
                return this.classifyFinishedTest(result);
            }
        }
        throw new PitError("Unhandled state");
    }

    private ResultType classifyFinishedTest(TestResult result) {
        if (result.getThrowable() != null) {
            if (this.assertionTypes.contains(result.getThrowable().getClass().getName())) {
                return ResultType.FAIL;
            }
            return ResultType.ERROR;
        }
        return ResultType.PASS;
    }
}

