/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.pitest.execute.Container;
import org.pitest.execute.ResultSource;
import org.pitest.execute.ResultType;
import org.pitest.execute.StaticConfiguration;
import org.pitest.functional.FCollection;
import org.pitest.functional.SideEffect1;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.GroupingStrategy;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnit;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pitest {
    private static final Logger LOG = Log.getLogger();
    private final StaticConfiguration initialStaticConfig;

    public Pitest(StaticConfiguration initialStaticConfig) {
        this.initialStaticConfig = initialStaticConfig;
    }

    public void run(Container defaultContainer, Configuration config, Class<?> ... classes) {
        this.run(defaultContainer, config, Arrays.asList(classes));
    }

    private void run(Container container, Configuration config, Collection<Class<?>> classes) {
        this.run(container, this.initialStaticConfig, Pitest.findTestUnitsForAllSuppliedClasses(config, this.initialStaticConfig.getGroupingStrategy(), classes));
    }

    public void run(Container container, List<? extends TestUnit> testUnits) {
        this.run(container, this.initialStaticConfig, testUnits);
    }

    private void run(Container container, StaticConfiguration staticConfig, List<? extends TestUnit> testUnits) {
        LOG.fine("Running " + testUnits.size() + " units");
        this.signalRunStartToAllListeners(staticConfig);
        Thread feederThread = this.startFeederThread(container, testUnits);
        this.processResultsFromQueue(container, feederThread, staticConfig);
    }

    private void signalRunStartToAllListeners(StaticConfiguration staticConfig) {
        FCollection.forEach(staticConfig.getTestListeners(), new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onRunStart();
            }
        });
    }

    public static List<TestUnit> findTestUnitsForAllSuppliedClasses(Configuration startConfig, GroupingStrategy groupStrategy, Iterable<Class<?>> classes) {
        ArrayList<TestUnit> testUnits = new ArrayList<TestUnit>();
        for (Class<?> c : classes) {
            Collection<TestUnit> testUnitsFromClass = Pitest.getTestUnits(c, startConfig, groupStrategy);
            testUnits.addAll(testUnitsFromClass);
        }
        return testUnits;
    }

    private static Collection<TestUnit> getTestUnits(Class<?> suiteClass, Configuration startConfig, GroupingStrategy groupStrategy) {
        ArrayList<TestUnit> tus = new ArrayList<TestUnit>();
        HashSet visitedClasses = new HashSet();
        Pitest.findTestUnits(tus, visitedClasses, suiteClass, startConfig, groupStrategy);
        return tus;
    }

    private static void findTestUnits(List<TestUnit> tus, Set<Class<?>> visitedClasses, Class<?> suiteClass, Configuration startConfig, GroupingStrategy groupStrategy) {
        visitedClasses.add(suiteClass);
        Collection tcs = (Collection)startConfig.testSuiteFinder().apply(suiteClass);
        for (Class tc : tcs) {
            if (visitedClasses.contains(tc)) continue;
            Pitest.findTestUnits(tus, visitedClasses, tc, startConfig, groupStrategy);
        }
        List<TestUnit> testsInThisClass = Pitest.getTestUnitsWithinClass(suiteClass, startConfig);
        if (!testsInThisClass.isEmpty()) {
            tus.addAll(groupStrategy.group(suiteClass, testsInThisClass));
        }
    }

    private static List<TestUnit> getTestUnitsWithinClass(Class<?> suiteClass, Configuration classConfig) {
        return classConfig.testUnitFinder().findTestUnits(suiteClass);
    }

    private void processResultsFromQueue(Container container, Thread feederThread, StaticConfiguration staticConfig) {
        ResultSource results = container.getResultSource();
        boolean isAlive = feederThread.isAlive();
        while (isAlive) {
            this.processResults(staticConfig, results);
            try {
                feederThread.join(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            isAlive = feederThread.isAlive();
        }
        container.shutdownWhenProcessingComplete();
        while (!container.awaitCompletion() || results.resultsAvailable()) {
            this.processResults(staticConfig, results);
        }
        this.signalRunEndToAllListeners(staticConfig);
        LOG.fine("Finished");
    }

    private void signalRunEndToAllListeners(StaticConfiguration staticConfig) {
        FCollection.forEach(staticConfig.getTestListeners(), new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onRunEnd();
            }
        });
    }

    private Thread startFeederThread(final Container container, final List<? extends TestUnit> callables) {
        Runnable feeder = new Runnable(){

            public void run() {
                for (TestUnit unit : callables) {
                    container.submit(unit);
                }
            }
        };
        Thread feederThread = new Thread(feeder);
        feederThread.start();
        return feederThread;
    }

    private void processResults(StaticConfiguration staticConfig, ResultSource source) {
        List<TestResult> results = source.getAvailableResults();
        for (TestResult result : results) {
            ResultType classifiedResult = staticConfig.getClassifier().classify(result);
            FCollection.forEach(staticConfig.getTestListeners(), classifiedResult.getListenerFunction(result));
        }
    }
}

