/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.execute.containers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.pitest.execute.Container;
import org.pitest.execute.ResultSource;
import org.pitest.execute.containers.ClassLoaderFactory;
import org.pitest.execute.containers.TestUnitExecutor;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnit;

public class BaseThreadPoolContainer
implements Container {
    private final ThreadPoolExecutor executor;
    private final ClassLoaderFactory loaderFactory;
    private final BlockingQueue<TestResult> feedbackQueue;

    public BaseThreadPoolContainer(Integer threads, ClassLoaderFactory loaderFactory, ThreadFactory threadFactory) {
        this.executor = new ThreadPoolExecutor((int)threads, (int)threads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.loaderFactory = loaderFactory;
        this.feedbackQueue = new ArrayBlockingQueue<TestResult>(6000);
    }

    private boolean awaitTermination(int i, TimeUnit milliseconds) throws InterruptedException {
        return this.executor.awaitTermination(i, milliseconds);
    }

    public void shutdownWhenProcessingComplete() {
        this.executor.shutdown();
    }

    private void submit(Runnable c) {
        this.executor.submit(c);
    }

    public void setMaxThreads(int maxThreads) {
        this.executor.setCorePoolSize(maxThreads);
        this.executor.setMaximumPoolSize(maxThreads);
    }

    public void submit(TestUnit c) {
        this.submit(new TestUnitExecutor(this.loaderFactory, c, this.feedbackQueue));
    }

    public boolean awaitCompletion() {
        try {
            return this.awaitTermination(10, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public ResultSource getResultSource() {
        return new ResultSource(){

            @Override
            public List<TestResult> getAvailableResults() {
                ArrayList<TestResult> results = new ArrayList<TestResult>();
                BaseThreadPoolContainer.this.feedbackQueue.drainTo(results);
                return results;
            }

            @Override
            public boolean resultsAvailable() {
                return !BaseThreadPoolContainer.this.feedbackQueue.isEmpty();
            }
        };
    }
}

