/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.execute.containers;

import java.util.concurrent.BlockingQueue;
import org.pitest.execute.containers.ExtendedTestResult;
import org.pitest.testapi.Description;
import org.pitest.testapi.MetaData;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnitState;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcreteResultCollector
implements ResultCollector {
    private final BlockingQueue<TestResult> feedback;

    public ConcreteResultCollector(BlockingQueue<TestResult> feedback) {
        this.feedback = feedback;
    }

    @Override
    public void notifyStart(Description tu) {
        this.put(new TestResult(tu, null, TestUnitState.STARTED));
    }

    @Override
    public void notifySkipped(Description tu) {
        this.put(new TestResult(tu, null, TestUnitState.NOT_RUN));
    }

    @Override
    public void notifyEnd(Description description, Throwable t, MetaData ... data) {
        if (data != null && data.length > 0) {
            this.put(new ExtendedTestResult(description, t, data));
        } else {
            this.put(new TestResult(description, t));
        }
    }

    @Override
    public void notifyEnd(Description description, MetaData ... data) {
        if (data != null && data.length > 0) {
            this.put(new ExtendedTestResult(description, null, data));
        } else {
            this.put(new TestResult(description, null));
        }
    }

    private void put(TestResult tr) {
        try {
            this.feedback.put(tr);
        }
        catch (InterruptedException e) {
            Unchecked.translateCheckedException(e);
        }
    }

    @Override
    public boolean shouldExit() {
        return false;
    }
}

