/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FunctionalCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.MutableList;
import org.pitest.functional.SideEffect1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FCollection {
    public static <A> void forEach(Iterable<? extends A> as, SideEffect1<A> e) {
        for (A a : as) {
            e.apply(a);
        }
    }

    public static <A, B> void mapTo(Iterable<? extends A> as, F<A, B> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                bs.add(f.apply(a));
            }
        }
    }

    public static <A, B> FunctionalList<B> map(Iterable<? extends A> as, F<A, B> f) {
        FunctionalList bs = FCollection.emptyList();
        FCollection.mapTo(as, f, bs);
        return bs;
    }

    public static <A, B> void flatMapTo(Iterable<? extends A> as, F<A, ? extends Iterable<B>> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                for (B each : f.apply(a)) {
                    bs.add(each);
                }
            }
        }
    }

    public static <A, B> FunctionalList<B> flatMap(Iterable<? extends A> as, F<A, ? extends Iterable<B>> f) {
        FunctionalList bs = FCollection.emptyList();
        FCollection.flatMapTo(as, f, bs);
        return bs;
    }

    private static <T> FunctionalList<T> emptyList() {
        return new MutableList();
    }

    public static <T> FunctionalList<T> filter(Iterable<? extends T> xs, F<T, Boolean> predicate) {
        FunctionalList<T> dest = FCollection.emptyList();
        FCollection.filter(xs, predicate, dest);
        return dest;
    }

    public static <T> void filter(Iterable<? extends T> xs, F<T, Boolean> predicate, Collection<? super T> dest) {
        for (T x : xs) {
            if (!predicate.apply(x).booleanValue()) continue;
            dest.add(x);
        }
    }

    public static <T> boolean contains(Iterable<? extends T> xs, F<T, Boolean> predicate) {
        for (T x : xs) {
            if (!predicate.apply(x).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <A, B> A fold(F2<A, B, A> f, A z, Iterable<? extends B> xs) {
        A p = z;
        for (B x : xs) {
            p = f.apply(p, x);
        }
        return p;
    }

    public static <T> FunctionalCollection<T> flatten(Iterable<? extends Iterable<? extends T>> ts) {
        MutableList<T> list = new MutableList<T>();
        for (Iterable<T> it : ts) {
            for (T each : it) {
                list.add(each);
            }
        }
        return list;
    }

    public static <T> FunctionalList<List<T>> splitToLength(int targetLength, Iterable<T> ts) {
        MutableList<List<T>> list = new MutableList<List<T>>();
        ArrayList<T> temp = new ArrayList<T>();
        int i = 0;
        for (T each : ts) {
            if (i == targetLength) {
                list.add(temp);
                temp = new ArrayList();
                i = 0;
            }
            temp.add(each);
            ++i;
        }
        if (!temp.isEmpty()) {
            list.add(temp);
        }
        return list;
    }

    public static <A, B> Map<A, Collection<B>> bucket(Iterable<B> bs, F<B, A> f) {
        HashMap<A, ArrayList<B>> bucketed = new HashMap<A, ArrayList<B>>();
        for (B each : bs) {
            A key = f.apply(each);
            ArrayList<B> existing = (ArrayList<B>)bucketed.get(key);
            if (existing == null) {
                existing = new ArrayList<B>();
                bucketed.put(key, existing);
            }
            existing.add(each);
        }
        return bucketed;
    }
}

