/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalIterable;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.SideEffect1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T>
implements FunctionalIterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final None NONE = new None();

    private Option() {
    }

    public abstract T value();

    public abstract T getOrElse(T var1);

    public abstract boolean hasSome();

    @Override
    public boolean contains(F<T, Boolean> predicate) {
        return FCollection.contains(this, predicate);
    }

    @Override
    public FunctionalList<T> filter(F<T, Boolean> predicate) {
        return FCollection.filter(this, predicate);
    }

    @Override
    public <B> FunctionalList<B> flatMap(F<T, ? extends Iterable<B>> f) {
        return FCollection.flatMap(this, f);
    }

    @Override
    public void forEach(SideEffect1<T> e) {
        FCollection.forEach(this, e);
    }

    @Override
    public <B> FunctionalList<B> map(F<T, B> f) {
        return FCollection.map(this, f);
    }

    @Override
    public <B> void mapTo(F<T, B> f, Collection<? super B> bs) {
        FCollection.mapTo(this, f, bs);
    }

    public static <T> Option<T> some(T value) {
        if (value == null) {
            return NONE;
        }
        return new Some(value);
    }

    public static <T> None<T> none() {
        return NONE;
    }

    public boolean hasNone() {
        return !this.hasSome();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Some<T>
    extends Option<T> {
        private static final long serialVersionUID = 1L;
        private final T value;

        private Some(T value) {
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.value).iterator();
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        @Override
        public boolean hasSome() {
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Some other = (Some)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class None<T>
    extends Option<T> {
        private static final long serialVersionUID = 1L;

        private None() {
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptySet().iterator();
        }

        @Override
        public T value() {
            throw new UnsupportedOperationException("Tried to retrieve value but had None.");
        }

        @Override
        public T getOrElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean hasSome() {
            return false;
        }
    }
}

