/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.runner.Version;
import org.pitest.extension.common.CompoundTestSuiteFinder;
import org.pitest.functional.Option;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.junit.CompoundTestUnitFinder;
import org.pitest.junit.JUnit4SuiteFinder;
import org.pitest.junit.JUnitCustomRunnerTestUnitFinder;
import org.pitest.junit.JUnitTestClassIdentifier;
import org.pitest.junit.ParameterisedJUnitTestFinder;
import org.pitest.junit.RunnerSuiteFinder;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestClassIdentifier;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCompatibleConfiguration
implements Configuration {
    private final TestGroupConfig config;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+).*");

    public JUnitCompatibleConfiguration(TestGroupConfig config) {
        this.config = config;
    }

    @Override
    public TestUnitFinder testUnitFinder() {
        return new CompoundTestUnitFinder(Arrays.asList(new JUnitCustomRunnerTestUnitFinder(), new ParameterisedJUnitTestFinder()));
    }

    @Override
    public TestSuiteFinder testSuiteFinder() {
        return new CompoundTestSuiteFinder(Arrays.asList(new JUnit4SuiteFinder(), new RunnerSuiteFinder()));
    }

    @Override
    public TestClassIdentifier testClassIdentifier() {
        return new JUnitTestClassIdentifier(this.config);
    }

    @Override
    public Option<PitHelpError> verifyEnvironment() {
        try {
            String version = Version.id();
            if (this.isInvalidVersion(version)) {
                return Option.some(new PitHelpError(Help.WRONG_JUNIT_VERSION, version));
            }
        }
        catch (NoClassDefFoundError er) {
            return Option.some(new PitHelpError(Help.NO_JUNIT, new Object[0]));
        }
        return Option.none();
    }

    boolean isInvalidVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return true;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return major < 4 || major == 4 && minor < 6;
    }
}

