/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runners.Parameterized;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.junit.DescriptionFilter;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.reflection.IsAnnotatedWith;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.IsolationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCustomRunnerTestUnitFinder
implements TestUnitFinder {
    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(clazz);
        if (this.isNotARunnableTest(runner, clazz.getName())) {
            return Collections.emptyList();
        }
        if (Filterable.class.isAssignableFrom(runner.getClass()) && !this.shouldTreatAsOneUnit(clazz, runner)) {
            return this.splitIntoFilteredUnits(runner.getDescription());
        }
        return Collections.singletonList(new AdaptedJUnitTestUnit(clazz, Option.<Filter>none()));
    }

    private boolean isNotARunnableTest(Runner runner, String className) {
        return runner == null || runner.getClass().isAssignableFrom(ErrorReportingRunner.class) || this.isParameterizedTest(runner) || this.isAJUnitThreeErrorOrWarning(runner) || this.isJUnitThreeSuiteMethodNotForOwnClass(runner, className);
    }

    private boolean isAJUnitThreeErrorOrWarning(Runner runner) {
        return !runner.getDescription().getChildren().isEmpty() && ((Description)runner.getDescription().getChildren().get(0)).getClassName().startsWith("junit.framework.TestSuite");
    }

    private boolean shouldTreatAsOneUnit(Class<?> clazz, Runner runner) {
        Set<Method> methods = Reflection.allMethods(clazz);
        return this.runnerCannotBeSplit(runner) || this.hasAnnotation(methods, BeforeClass.class) || this.hasAnnotation(methods, AfterClass.class);
    }

    private boolean hasAnnotation(Set<Method> methods, Class<? extends Annotation> annotation) {
        return FCollection.contains(methods, IsAnnotatedWith.instance(annotation));
    }

    private boolean isParameterizedTest(Runner runner) {
        return Parameterized.class.isAssignableFrom(runner.getClass());
    }

    private boolean runnerCannotBeSplit(Runner runner) {
        String runnerName = runner.getClass().getName();
        return runnerName.equals("junitparams.JUnitParamsRunner") || runnerName.startsWith("org.spockframework.runtime.Sputnik");
    }

    private boolean isJUnitThreeSuiteMethodNotForOwnClass(Runner runner, String className) {
        return runner.getClass().getName().equals("org.junit.internal.runners.SuiteMethod") && !runner.getDescription().getClassName().equals(className);
    }

    private List<TestUnit> splitIntoFilteredUnits(Description description) {
        return FCollection.filter(description.getChildren(), this.isTest()).map(this.descriptionToTestUnit());
    }

    private F<Description, TestUnit> descriptionToTestUnit() {
        return new F<Description, TestUnit>(){

            @Override
            public TestUnit apply(Description a) {
                return JUnitCustomRunnerTestUnitFinder.this.descriptionToTest(a);
            }
        };
    }

    private F<Description, Boolean> isTest() {
        return new F<Description, Boolean>(){

            @Override
            public Boolean apply(Description a) {
                return a.isTest();
            }
        };
    }

    private TestUnit descriptionToTest(Description description) {
        Class<?> clazz = description.getTestClass();
        if (clazz == null) {
            clazz = IsolationUtils.convertForClassLoader(IsolationUtils.getContextClassLoader(), description.getClassName());
        }
        return new AdaptedJUnitTestUnit(clazz, Option.some(this.createFilterFor(description)));
    }

    private Filter createFilterFor(Description description) {
        return new DescriptionFilter(description.toString());
    }
}

