/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.testapi.TestSuiteFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerSuiteFinder
implements TestSuiteFinder {
    @Override
    public List<Class<?>> apply(Class<?> a) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(a);
        ArrayList<Description> allChildren = new ArrayList<Description>();
        this.flattenChildren(allChildren, runner.getDescription());
        LinkedHashSet classes = new LinkedHashSet(runner.getDescription().getChildren().size());
        FunctionalList<Description> suites = FCollection.filter(allChildren, Prelude.or(RunnerSuiteFinder.isSuiteMethodRunner(runner), RunnerSuiteFinder.isSuite()));
        FCollection.flatMapTo(suites, RunnerSuiteFinder.descriptionToTestClass(), classes);
        classes.remove(a);
        return new ArrayList(classes);
    }

    private void flattenChildren(List<Description> allChildren, Description description) {
        for (Description each : description.getChildren()) {
            allChildren.add(each);
            this.flattenChildren(allChildren, each);
        }
    }

    private static Predicate<Description> isSuiteMethodRunner(final Runner runner) {
        return new Predicate<Description>(){

            @Override
            public Boolean apply(Description a) {
                return SuiteMethod.class.isAssignableFrom(runner.getClass());
            }
        };
    }

    private static F<Description, Option<Class<?>>> descriptionToTestClass() {
        return new F<Description, Option<Class<?>>>(){

            @Override
            public Option<Class<?>> apply(Description a) {
                Class clazz = a.getTestClass();
                if (clazz != null) {
                    return Option.some(clazz);
                }
                return Option.none();
            }
        };
    }

    private static Predicate<Description> isSuite() {
        return new Predicate<Description>(){

            @Override
            public Boolean apply(Description a) {
                return a.isSuite();
            }
        };
    }
}

