/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pitest.classinfo.ClassInfo;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TestInfo {
    TestInfo() {
    }

    public static boolean isWithinATestClass(ClassInfo clazz) {
        Option<ClassInfo> outerClass = clazz.getOuterClass();
        return TestInfo.isATest(clazz) || outerClass.hasSome() && TestInfo.isATest(outerClass.value());
    }

    private static boolean isATest(ClassInfo clazz) {
        return TestInfo.isJUnit3Test(clazz) || TestInfo.isJUnit4Test(clazz) || TestInfo.isATest(clazz.getSuperClass());
    }

    private static boolean isATest(Option<ClassInfo> clazz) {
        if (clazz.hasSome()) {
            return TestInfo.isATest(clazz.value());
        }
        return false;
    }

    public static Predicate<ClassInfo> isATest() {
        return new Predicate<ClassInfo>(){

            @Override
            public Boolean apply(ClassInfo clazz) {
                return TestInfo.isATest(clazz);
            }
        };
    }

    private static boolean isJUnit3Test(ClassInfo clazz) {
        return clazz.descendsFrom(TestCase.class) || clazz.descendsFrom(TestSuite.class);
    }

    private static boolean isJUnit4Test(ClassInfo clazz) {
        return clazz.hasAnnotation(RunWith.class) || clazz.hasAnnotation(Test.class);
    }
}

