/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit.adapter;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.model.RunnerBuilder;
import org.pitest.functional.Option;
import org.pitest.junit.adapter.CustomRunnerExecutor;
import org.pitest.junit.adapter.ForeignClassLoaderCustomRunnerExecutor;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.foreignclassloader.Events;
import org.pitest.util.ClassLoaderDetectionStrategy;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptedJUnitTestUnit
extends AbstractTestUnit {
    private static final Logger LOG = Log.getLogger();
    private final ClassLoaderDetectionStrategy loaderDetection;
    private final Class<?> clazz;
    private final Option<Filter> filter;

    public AdaptedJUnitTestUnit(Class<?> clazz, Option<Filter> filter) {
        this(IsolationUtils.loaderDetectionStrategy(), clazz, filter);
    }

    AdaptedJUnitTestUnit(ClassLoaderDetectionStrategy loaderDetection, Class<?> clazz, Option<Filter> filter) {
        super(new Description(AdaptedJUnitTestUnit.createName(clazz, filter), clazz));
        this.loaderDetection = loaderDetection;
        this.clazz = clazz;
        this.filter = filter;
    }

    private static String createName(Class<?> clazz, Option<Filter> filter) {
        if (filter.hasSome()) {
            return filter.value().describe();
        }
        return clazz.getName();
    }

    @Override
    public void execute(ClassLoader loader, ResultCollector rc) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(this.clazz);
        this.checkForErrorRunner(runner);
        this.filterIfRequired(rc, runner);
        try {
            if (this.loaderDetection.fromDifferentLoader(runner.getClass(), loader)) {
                this.executeInDifferentClassLoader(loader, rc, runner);
            } else {
                CustomRunnerExecutor nativeCe = new CustomRunnerExecutor(this.getDescription(), runner, rc);
                nativeCe.run();
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while running adapter JUnit fixture " + this.clazz + " with filter " + this.filter, e);
            throw Unchecked.translateCheckedException(e);
        }
    }

    private void checkForErrorRunner(Runner runner) {
        if (runner instanceof ErrorReportingRunner) {
            LOG.warning("JUnit error for class " + this.clazz + " : " + runner.getDescription());
        }
    }

    private void filterIfRequired(ResultCollector rc, Runner runner) {
        if (this.filter.hasSome()) {
            if (!(runner instanceof Filterable)) {
                LOG.warning("Not able to filter " + runner.getDescription() + ". Mutation may have prevented JUnit from constructing test");
                return;
            }
            Filterable f = (Filterable)runner;
            try {
                f.filter(this.filter.value());
            }
            catch (NoTestsRemainException e1) {
                rc.notifySkipped(this.getDescription());
                return;
            }
        }
    }

    public static Runner createRunner(Class<?> clazz) {
        RunnerBuilder builder = AdaptedJUnitTestUnit.createRunnerBuilder(clazz);
        try {
            return builder.runnerForClass(clazz);
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Error while creating runner for " + clazz, ex);
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private static RunnerBuilder createRunnerBuilder(Class<?> clazz) {
        return new AllDefaultPossibilitiesBuilder(true);
    }

    private void executeInDifferentClassLoader(ClassLoader loader, ResultCollector rc, Runner runner) throws IllegalAccessException, InvocationTargetException {
        ForeignClassLoaderCustomRunnerExecutor ce = new ForeignClassLoaderCustomRunnerExecutor(runner);
        Callable foreignCe = (Callable)IsolationUtils.cloneForLoader(ce, loader);
        try {
            List q = (List)foreignCe.call();
            this.convertStringsToResults(rc, q);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private void convertStringsToResults(ResultCollector rc, List<String> q) {
        Events.applyEvents(q, rc, this.getDescription());
    }

    public String toString() {
        return "AdaptedJUnitTestUnit [clazz=" + this.clazz + ", filter=" + this.filter + "]";
    }
}

