/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit.adapter;

import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pitest.functional.SideEffect2;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.foreignclassloader.Fail;
import org.pitest.testapi.foreignclassloader.Skipped;
import org.pitest.testapi.foreignclassloader.Start;
import org.pitest.testapi.foreignclassloader.Success;
import org.pitest.util.IsolationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForeignClassLoaderAdaptingRunListener
extends RunListener {
    private final List<String> events;
    private boolean finished = false;

    public ForeignClassLoaderAdaptingRunListener(List<String> queue) {
        this.events = queue;
    }

    public void testFailure(Failure failure) throws Exception {
        this.storeAsString(new Fail(failure.getException()));
        this.finished = true;
    }

    public void testAssumptionFailure(Failure failure) {
    }

    public void testIgnored(Description description) throws Exception {
        this.storeAsString(new Skipped());
        this.finished = true;
    }

    public void testStarted(Description description) throws Exception {
        this.storeAsString(new Start());
    }

    public void testFinished(Description description) throws Exception {
        if (!this.finished) {
            this.storeAsString(new Success());
        }
    }

    private void storeAsString(SideEffect2<ResultCollector, org.pitest.testapi.Description> result) {
        this.events.add(IsolationUtils.toXml(result));
    }
}

