/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import org.pitest.functional.Option;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationResult {
    private final MutationDetails details;
    private final MutationStatusTestPair status;

    public MutationResult(MutationDetails md, MutationStatusTestPair status) {
        this.details = md;
        this.status = status;
    }

    public MutationDetails getDetails() {
        return this.details;
    }

    public Option<String> getKillingTest() {
        return this.status.getKillingTest();
    }

    public DetectionStatus getStatus() {
        return this.status.getStatus();
    }

    public int getNumberOfTestsRun() {
        return this.status.getNumberOfTestsRun();
    }

    public MutationStatusTestPair getStatusTestPair() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.getStatus().name();
    }

    public String getKillingTestDescription() {
        return this.getKillingTest().getOrElse("none");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationResult other = (MutationResult)obj;
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public String toString() {
        return "MutationResult [details=" + this.details + ", status=" + this.status + "]";
    }
}

