/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import org.pitest.functional.Option;
import org.pitest.mutationtest.DetectionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationStatusTestPair {
    private final int numberOfTestsRun;
    private final DetectionStatus status;
    private final Option<String> killingTest;

    public MutationStatusTestPair(int numberOfTestsRun, DetectionStatus status) {
        this(numberOfTestsRun, status, null);
    }

    public MutationStatusTestPair(int numberOfTestsRun, DetectionStatus status, String killingTest) {
        this.status = status;
        this.killingTest = Option.some(killingTest);
        this.numberOfTestsRun = numberOfTestsRun;
    }

    public DetectionStatus getStatus() {
        return this.status;
    }

    public Option<String> getKillingTest() {
        return this.killingTest;
    }

    public int getNumberOfTestsRun() {
        return this.numberOfTestsRun;
    }

    public String toString() {
        if (this.killingTest.hasNone()) {
            return this.status.name();
        }
        return this.status.name() + " by " + this.killingTest.value();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.killingTest == null ? 0 : this.killingTest.hashCode());
        result = 31 * result + this.numberOfTestsRun;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationStatusTestPair other = (MutationStatusTestPair)obj;
        if (this.killingTest == null ? other.killingTest != null : !this.killingTest.equals(other.killingTest)) {
            return false;
        }
        if (this.numberOfTestsRun != other.numberOfTestsRun) {
            return false;
        }
        return this.status == other.status;
    }
}

