/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.engine.MutationDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrouper
implements MutationGrouper {
    private final int unitSize;

    public DefaultGrouper(int unitSize) {
        this.unitSize = unitSize;
    }

    @Override
    public List<List<MutationDetails>> groupMutations(Collection<ClassName> codeClasses, Collection<MutationDetails> mutations) {
        Map<ClassName, Collection<MutationDetails>> bucketed = FCollection.bucket(mutations, DefaultGrouper.byClass());
        ArrayList<List<MutationDetails>> chunked = new ArrayList<List<MutationDetails>>();
        for (Collection<MutationDetails> each : bucketed.values()) {
            this.shrinkToMaximumUnitSize(chunked, each);
        }
        return chunked;
    }

    private void shrinkToMaximumUnitSize(List<List<MutationDetails>> chunked, Collection<MutationDetails> each) {
        if (this.unitSize > 0) {
            for (List list : FCollection.splitToLength(this.unitSize, each)) {
                chunked.add(list);
            }
        } else {
            chunked.add(new ArrayList<MutationDetails>(each));
        }
    }

    private static F<MutationDetails, ClassName> byClass() {
        return new F<MutationDetails, ClassName>(){

            @Override
            public ClassName apply(MutationDetails a) {
                return a.getClassName();
            }
        };
    }

    public String description() {
        return "Default grouping";
    }
}

