/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.List;
import java.util.logging.Logger;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.MetaData;
import org.pitest.testapi.ResultCollector;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownStatusMutationTestUnit
extends AbstractTestUnit
implements MutationAnalysisUnit {
    private static final Logger LOG = Log.getLogger();
    private final List<MutationResult> mutations;

    public KnownStatusMutationTestUnit(List<MutationResult> mutations) {
        super(new Description("Mutation test"));
        this.mutations = mutations;
    }

    @Override
    public void execute(ClassLoader loader, ResultCollector rc) {
        try {
            LOG.fine("Using historic results for " + this.mutations.size() + " mutations");
            rc.notifyStart(this.getDescription());
            this.reportResults(rc);
        }
        catch (Throwable ex) {
            rc.notifyEnd(this.getDescription(), ex, new MetaData[0]);
        }
    }

    private void reportResults(ResultCollector rc) {
        MutationMetaData md = new MutationMetaData(this.mutations);
        rc.notifyEnd(this.getDescription(), md);
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }
}

