/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationStatusMap;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.execute.MutationTestProcess;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.MetaData;
import org.pitest.testapi.ResultCollector;
import org.pitest.util.ExitCode;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationTestUnit
extends AbstractTestUnit
implements MutationAnalysisUnit {
    private static final Logger LOG = Log.getLogger();
    private final MutationConfig config;
    private final Collection<MutationDetails> availableMutations;
    private final WorkerFactory workerFactory;
    private final Collection<ClassName> testClasses;

    public MutationTestUnit(Collection<MutationDetails> availableMutations, Collection<ClassName> testClasses, MutationConfig mutationConfig, WorkerFactory workerFactor) {
        super(new Description("Mutation test"));
        this.availableMutations = availableMutations;
        this.config = mutationConfig;
        this.testClasses = testClasses;
        this.workerFactory = workerFactor;
    }

    @Override
    public void execute(ClassLoader loader, ResultCollector rc) {
        try {
            rc.notifyStart(this.getDescription());
            this.runTests(rc);
        }
        catch (Throwable ex) {
            rc.notifyEnd(this.getDescription(), ex, new MetaData[0]);
        }
    }

    private void runTests(ResultCollector rc) {
        try {
            if (!this.availableMutations.isEmpty()) {
                this.runTestsForMutations(rc);
            } else {
                LOG.fine("No mutations to detect");
                rc.notifySkipped(this.getDescription());
            }
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private void runTestsForMutations(ResultCollector rc) throws IOException, InterruptedException {
        MutationStatusMap mutations = new MutationStatusMap();
        mutations.setStatusForMutations(this.availableMutations, DetectionStatus.NOT_STARTED);
        mutations.markUncoveredMutations();
        this.runTestsInSeperateProcess(mutations);
        this.reportResults(mutations, rc);
    }

    private void runTestInSeperateProcessForMutationRange(MutationStatusMap mutations) throws IOException, InterruptedException {
        Collection<MutationDetails> remainingMutations = mutations.getUnrunMutations();
        MutationTestProcess worker = this.workerFactory.createWorker(remainingMutations, this.testClasses);
        worker.start();
        this.setFirstMutationToStatusOfStartedInCaseSlaveFailsAtBoot(mutations, remainingMutations);
        ExitCode exitCode = this.waitForSlaveToDie(worker);
        worker.results(mutations);
        this.correctResultForProcessExitCode(mutations, exitCode);
    }

    private ExitCode waitForSlaveToDie(MutationTestProcess worker) {
        ExitCode exitCode = worker.waitToDie();
        LOG.fine("Exit code was - " + (Object)((Object)exitCode));
        return exitCode;
    }

    private void setFirstMutationToStatusOfStartedInCaseSlaveFailsAtBoot(MutationStatusMap mutations, Collection<MutationDetails> remainingMutations) {
        mutations.setStatusForMutation(remainingMutations.iterator().next(), DetectionStatus.STARTED);
    }

    private void correctResultForProcessExitCode(MutationStatusMap mutations, ExitCode exitCode) {
        if (!exitCode.isOk()) {
            Collection<MutationDetails> unfinishedRuns = mutations.getUnfinishedRuns();
            DetectionStatus status = DetectionStatus.getForErrorExitCode(exitCode);
            LOG.warning("Slave exited abnormally due to " + (Object)((Object)status));
            LOG.fine("Setting " + unfinishedRuns.size() + " unfinished runs to " + (Object)((Object)status) + " state");
            mutations.setStatusForMutations(unfinishedRuns, status);
        } else {
            LOG.fine("Slave exited ok");
        }
    }

    private void runTestsInSeperateProcess(MutationStatusMap mutations) throws IOException, InterruptedException {
        while (mutations.hasUnrunMutations()) {
            this.runTestInSeperateProcessForMutationRange(mutations);
        }
    }

    private void reportResults(MutationStatusMap mutationsMap, ResultCollector rc) {
        MutationMetaData md = new MutationMetaData(mutationsMap.createMutationResults());
        rc.notifyEnd(this.getDescription(), md);
    }

    public MutationConfig getMutationConfig() {
        return this.config;
    }

    @Override
    public int priority() {
        return this.availableMutations.size();
    }
}

