/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.io.File;
import java.util.Collection;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.execute.MutationTestProcess;
import org.pitest.mutationtest.execute.SlaveArguments;
import org.pitest.process.ProcessArgs;
import org.pitest.testapi.Configuration;
import org.pitest.util.Log;
import org.pitest.util.SocketFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerFactory {
    private final String classPath;
    private final File baseDir;
    private final Configuration pitConfig;
    private final TimeoutLengthStrategy timeoutStrategy;
    private final boolean verbose;
    private final MutationConfig config;

    public WorkerFactory(File baseDir, Configuration pitConfig, MutationConfig mutationConfig, TimeoutLengthStrategy timeoutStrategy, boolean verbose, String classPath) {
        this.pitConfig = pitConfig;
        this.timeoutStrategy = timeoutStrategy;
        this.verbose = verbose;
        this.classPath = classPath;
        this.baseDir = baseDir;
        this.config = mutationConfig;
    }

    public MutationTestProcess createWorker(Collection<MutationDetails> remainingMutations, Collection<ClassName> testClasses) {
        SlaveArguments fileArgs = new SlaveArguments(remainingMutations, testClasses, this.config.getEngine(), this.timeoutStrategy, Log.isVerbose(), this.pitConfig);
        ProcessArgs args = ProcessArgs.withClassPath(this.classPath).andLaunchOptions(this.config.getLaunchOptions()).andBaseDir(this.baseDir).andStdout(this.captureStdOutIfVerbose()).andStderr(Prelude.printWith("stderr "));
        SocketFinder sf = new SocketFinder();
        MutationTestProcess worker = new MutationTestProcess(sf.getNextAvailableServerSocket(), args, fileArgs);
        return worker;
    }

    private SideEffect1<String> captureStdOutIfVerbose() {
        if (this.verbose) {
            return Prelude.printWith("stdout ");
        }
        return Prelude.noSideEffect(String.class);
    }
}

