/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import org.pitest.extension.common.CompoundTestSuiteFinder;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.help.PitHelpError;
import org.pitest.junit.CompoundTestUnitFinder;
import org.pitest.mutationtest.config.CompoundTestClassIdentifier;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestClassIdentifier;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundConfiguration
implements Configuration {
    private final Iterable<Configuration> configs;
    private final CompoundTestUnitFinder testUnitFinder;
    private final CompoundTestSuiteFinder suiteFinder;
    private final CompoundTestClassIdentifier testIdentifier;

    public CompoundConfiguration(Iterable<Configuration> configs) {
        this.configs = configs;
        this.testUnitFinder = new CompoundTestUnitFinder(FCollection.map(configs, CompoundConfiguration.asTestUnitFinders()));
        this.suiteFinder = new CompoundTestSuiteFinder(FCollection.map(configs, CompoundConfiguration.asSuiteFinders()));
        this.testIdentifier = new CompoundTestClassIdentifier(FCollection.map(configs, CompoundConfiguration.asTestIdentifier()));
    }

    private static F<Configuration, TestClassIdentifier> asTestIdentifier() {
        return new F<Configuration, TestClassIdentifier>(){

            @Override
            public TestClassIdentifier apply(Configuration a) {
                return a.testClassIdentifier();
            }
        };
    }

    private static F<Configuration, TestSuiteFinder> asSuiteFinders() {
        return new F<Configuration, TestSuiteFinder>(){

            @Override
            public TestSuiteFinder apply(Configuration a) {
                return a.testSuiteFinder();
            }
        };
    }

    private static F<Configuration, TestUnitFinder> asTestUnitFinders() {
        return new F<Configuration, TestUnitFinder>(){

            @Override
            public TestUnitFinder apply(Configuration a) {
                return a.testUnitFinder();
            }
        };
    }

    @Override
    public TestUnitFinder testUnitFinder() {
        return this.testUnitFinder;
    }

    @Override
    public TestSuiteFinder testSuiteFinder() {
        return this.suiteFinder;
    }

    @Override
    public TestClassIdentifier testClassIdentifier() {
        return this.testIdentifier;
    }

    @Override
    public Option<PitHelpError> verifyEnvironment() {
        FunctionalList<PitHelpError> verificationResults = FCollection.flatMap(this.configs, CompoundConfiguration.verify());
        if (verificationResults.isEmpty()) {
            return Option.none();
        }
        return Option.some(verificationResults.iterator().next());
    }

    private static F<Configuration, Iterable<PitHelpError>> verify() {
        return new F<Configuration, Iterable<PitHelpError>>(){

            @Override
            public Iterable<PitHelpError> apply(Configuration a) {
                return a.verifyEnvironment();
            }
        };
    }
}

