/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigOption {
    REPORT_DIR("reportDir"),
    TARGET_CLASSES("targetClasses"),
    SOURCE_DIR("sourceDirs"),
    MUTATIONS("mutators"),
    DEPENDENCY_DISTANCE("dependencyDistance", -1),
    CHILD_JVM("jvmArgs"),
    MUTATE_STATIC_INITIALIZERS("mutateStaticInits", false),
    TIME_STAMPED_REPORTS("timestampedReports", true),
    THREADS("threads", 1),
    TIMEOUT_FACTOR("timeoutFactor", Float.valueOf(1.25f)),
    TIMEOUT_CONST("timeoutConst", 4000L),
    TEST_FILTER("targetTests"),
    AVOID_CALLS("avoidCallsTo"),
    EXCLUDED_METHOD("excludedMethods"),
    MAX_MUTATIONS_PER_CLASS("maxMutationsPerClass", 0),
    VERBOSE("verbose", false),
    EXCLUDED_CLASSES("excludedClasses"),
    OUTPUT_FORMATS("outputFormats"),
    PROJECT_FILE("configFile"),
    CLASSPATH("classPath"),
    FAIL_WHEN_NOT_MUTATIONS("failWhenNoMutations", true),
    CODE_PATHS("mutableCodePaths"),
    INCLUDED_GROUPS("includedGroups"),
    EXCLUDED_GROUPS("excludedGroups"),
    MUTATION_UNIT_SIZE("mutationUnitSize", 0),
    USE_INLINED_CODE_DETECTION("detectInlinedCode", true),
    HISTORY_INPUT_LOCATION("historyInputLocation"),
    HISTORY_OUTPUT_LOCATION("historyOutputLocation"),
    MUTATION_THRESHOLD("mutationThreshold", 0),
    COVERAGE_THRESHOLD("coverageThreshold", 0),
    MUTATION_ENGINE("mutationEngine", "gregor"),
    EXPORT_LINE_COVERAGE("exportLineCoverage", false),
    INCLUDE_LAUNCH_CLASSPATH("includeLaunchClasspath", true),
    JVM_PATH("jvmPath");

    private final String text;
    private final Object defaultValue;

    private ConfigOption(String text) {
        this(text, null);
    }

    private ConfigOption(String text, Object defaultValue) {
        this.text = text;
        this.defaultValue = defaultValue;
    }

    public String getParamName() {
        return this.text;
    }

    public <T> T getDefault(Class<T> type) {
        return (T)this.defaultValue;
    }

    public String toString() {
        return this.text;
    }
}

