/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.ArrayList;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.Repository;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.junit.JUnitCompatibleConfiguration;
import org.pitest.mutationtest.config.CompoundConfiguration;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testng.TestNGConfiguration;

public class ConfigurationFactory {
    private final ClassByteArraySource source;
    private final TestGroupConfig config;

    public ConfigurationFactory(TestGroupConfig config, ClassByteArraySource source) {
        this.source = source;
        this.config = config;
    }

    public Configuration createConfiguration() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        Repository classRepository = new Repository(this.source);
        if (classRepository.fetchClass(ClassName.fromString("org.junit.runner.Runner")).hasSome()) {
            configs.add(new JUnitCompatibleConfiguration(this.config));
        }
        if (classRepository.fetchClass(ClassName.fromString("org.testng.TestNG")).hasSome()) {
            configs.add(new TestNGConfiguration(this.config));
        }
        if (configs.isEmpty()) {
            throw new PitHelpError(Help.NO_TEST_LIBRARY, new Object[0]);
        }
        return new CompoundConfiguration(configs);
    }
}

