/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.Collection;
import org.pitest.coverage.CoverageExporter;
import org.pitest.coverage.export.DefaultCoverageExporter;
import org.pitest.coverage.export.NullCoverageExporter;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.build.DefaultMutationGrouperFactory;
import org.pitest.mutationtest.build.DefaultTestPrioritiserFactory;
import org.pitest.mutationtest.build.MutationGrouperFactory;
import org.pitest.mutationtest.build.TestPrioritiserFactory;
import org.pitest.mutationtest.config.CompoundListenerFactory;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.filter.CompoundFilterFactory;
import org.pitest.mutationtest.filter.MutationFilterFactory;
import org.pitest.process.DefaultJavaExecutableLocator;
import org.pitest.process.JavaExecutableLocator;
import org.pitest.process.KnownLocationJavaExecutableLocator;
import org.pitest.util.PitError;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsFactory {
    private final ReportOptions options;
    private final PluginServices plugins;

    public SettingsFactory(ReportOptions options, PluginServices plugins) {
        this.options = options;
        this.plugins = plugins;
    }

    public ResultOutputStrategy getOutputStrategy() {
        return this.options.getReportDirectoryStrategy();
    }

    public CoverageExporter createCoverageExporter() {
        if (this.options.shouldExportLineCoverage()) {
            return new DefaultCoverageExporter(this.getOutputStrategy());
        }
        return new NullCoverageExporter();
    }

    public MutationEngineFactory createEngine() {
        for (MutationEngineFactory mutationEngineFactory : this.plugins.findMutationEngines()) {
            if (!mutationEngineFactory.name().equals(this.options.getMutationEngine())) continue;
            return mutationEngineFactory;
        }
        throw new PitError("Could not load requested engine " + this.options.getMutationEngine());
    }

    public MutationResultListenerFactory createListener() {
        return new CompoundListenerFactory(this.findListeners());
    }

    public JavaExecutableLocator getJavaExecutable() {
        if (this.options.getJavaExecutable() != null) {
            return new KnownLocationJavaExecutableLocator(this.options.getJavaExecutable());
        }
        return new DefaultJavaExecutableLocator();
    }

    public MutationGrouperFactory getMutationGrouper() {
        Collection<? extends MutationGrouperFactory> groupers = this.plugins.findGroupers();
        return SettingsFactory.firstOrDefault(groupers, new DefaultMutationGrouperFactory());
    }

    private Iterable<MutationResultListenerFactory> findListeners() {
        Collection<? extends MutationResultListenerFactory> listeners = this.plugins.findListeners();
        FunctionalList<MutationResultListenerFactory> matches = FCollection.filter(listeners, SettingsFactory.nameMatches(this.options.getOutputFormats()));
        if (matches.size() < this.options.getOutputFormats().size()) {
            throw new PitError("Unknown listener requested in " + StringUtil.join(this.options.getOutputFormats(), ","));
        }
        return matches;
    }

    private static F<MutationResultListenerFactory, Boolean> nameMatches(final Iterable<String> outputFormats) {
        return new F<MutationResultListenerFactory, Boolean>(){

            @Override
            public Boolean apply(MutationResultListenerFactory a) {
                return FCollection.contains(outputFormats, SettingsFactory.equalsIgnoreCase(a.name()));
            }
        };
    }

    private static Predicate<String> equalsIgnoreCase(final String other) {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return a.equalsIgnoreCase(other);
            }
        };
    }

    public MutationFilterFactory createMutationFilter() {
        Collection<? extends MutationFilterFactory> filters = this.plugins.findFilters();
        return new CompoundFilterFactory(filters);
    }

    public TestPrioritiserFactory getTestPrioritiser() {
        Collection<? extends TestPrioritiserFactory> testPickers = this.plugins.findTestPrioritisers();
        return SettingsFactory.firstOrDefault(testPickers, new DefaultTestPrioritiserFactory());
    }

    private static <T> T firstOrDefault(Collection<? extends T> found, T defaultInstance) {
        if (found.isEmpty()) {
            return defaultInstance;
        }
        if (found.size() > 1) {
            throw new PitError("Multiple implementations of plugin detected on classpath");
        }
        return found.iterator().next();
    }
}

