/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationIdentifier
implements Comparable<MutationIdentifier> {
    private final Location location;
    private final List<Integer> indexes;
    private final String mutator;

    public MutationIdentifier(Location location, int index, String mutatorUniqueId) {
        this(location, Collections.singleton(index), mutatorUniqueId);
    }

    public MutationIdentifier(Location location, Collection<Integer> indexes, String mutatorUniqueId) {
        this.location = location;
        this.indexes = new ArrayList<Integer>(indexes);
        this.mutator = mutatorUniqueId;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMutator() {
        return this.mutator;
    }

    public int getFirstIndex() {
        return this.indexes.iterator().next();
    }

    public MutationIdentifier withLocation(Location location) {
        return new MutationIdentifier(location, this.indexes, this.mutator);
    }

    public MutationIdentifier withMutator(String mutator) {
        return new MutationIdentifier(this.location, this.indexes, mutator);
    }

    public MutationIdentifier withIndex(int id) {
        return new MutationIdentifier(this.location, id, this.mutator);
    }

    public String toString() {
        return "MutationIdentifier [location=" + this.location + ", indexes=" + this.indexes + ", mutator=" + this.mutator + "]";
    }

    public boolean matches(MutationIdentifier newId) {
        return this.location.equals(newId.location) && this.mutator.equals(newId.mutator) && this.indexes.contains(newId.getFirstIndex());
    }

    public ClassName getClassName() {
        return this.location.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.mutator == null ? 0 : this.mutator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationIdentifier other = (MutationIdentifier)obj;
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.mutator == null ? other.mutator != null : !this.mutator.equals(other.mutator));
    }

    @Override
    public int compareTo(MutationIdentifier other) {
        int comp = this.location.compareTo(other.getLocation());
        if (comp != 0) {
            return comp;
        }
        comp = this.mutator.compareTo(other.getMutator());
        if (comp != 0) {
            return comp;
        }
        return this.indexes.get(0).compareTo(other.indexes.get(0));
    }
}

