/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Map;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.ZeroOperandMutation;
import org.pitest.reloc.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInsnMutator
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final Context context;
    private final MethodInfo methodInfo;

    public AbstractInsnMutator(MethodMutatorFactory factory, MethodInfo methodInfo, Context context, MethodVisitor delegateMethodVisitor) {
        super(327680, delegateMethodVisitor);
        this.factory = factory;
        this.methodInfo = methodInfo;
        this.context = context;
    }

    protected abstract Map<Integer, ZeroOperandMutation> getMutations();

    @Override
    public void visitInsn(int opcode) {
        if (this.canMutate(opcode)) {
            this.createMutationForInsnOpcode(opcode);
        } else {
            this.mv.visitInsn(opcode);
        }
    }

    private boolean canMutate(int opcode) {
        return this.getMutations().containsKey(opcode);
    }

    private void createMutationForInsnOpcode(int opcode) {
        ZeroOperandMutation mutation = this.getMutations().get(opcode);
        MutationIdentifier newId = this.context.registerMutation(this.factory, mutation.decribe(opcode, this.methodInfo));
        if (this.context.shouldMutate(newId)) {
            mutation.apply(opcode, this.mv);
        } else {
            this.applyUnmutatedInstruction(opcode);
        }
    }

    private void applyUnmutatedInstruction(int opcode) {
        this.mv.visitInsn(opcode);
    }
}

