/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.MutableList;
import org.pitest.functional.Option;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.blocks.BlockCounter;
import org.pitest.mutationtest.engine.gregor.blocks.ConcreteBlockCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements BlockCounter {
    private final Map<String, Integer> mutatorIndexes = new HashMap<String, Integer>();
    private final ConcreteBlockCounter blockCounter = new ConcreteBlockCounter();
    private int lastLineNumber;
    private ClassInfo classInfo;
    private String sourceFile;
    private Option<MutationIdentifier> target = Option.none();
    private final FunctionalList<MutationDetails> mutations = new MutableList<MutationDetails>();
    private Location location;
    private final Set<String> mutationFindingDisabledReasons = new HashSet<String>();

    private void registerMutation(MutationDetails details) {
        if (!this.isMutationFindingDisabled()) {
            this.mutations.add(details);
        }
    }

    private boolean isMutationFindingDisabled() {
        return !this.mutationFindingDisabledReasons.isEmpty();
    }

    public Option<MutationIdentifier> getTargetMutation() {
        return this.target;
    }

    private MutationIdentifier getNextMutationIdentifer(MethodMutatorFactory factory, String className) {
        int index = this.getAndIncrementIndex(factory);
        return new MutationIdentifier(this.location, index, factory.getGloballyUniqueId());
    }

    private int getAndIncrementIndex(MethodMutatorFactory factory) {
        Integer index = this.mutatorIndexes.get(factory.getGloballyUniqueId());
        if (index == null) {
            index = 0;
        }
        this.mutatorIndexes.put(factory.getGloballyUniqueId(), index + 1);
        return index;
    }

    public Collection<MutationDetails> getCollectedMutations() {
        return this.mutations;
    }

    public void registerCurrentLine(int line) {
        this.lastLineNumber = line;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    private String getJavaClassName() {
        return this.classInfo.getName().replace("/", ".");
    }

    public String getFileName() {
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.lastLineNumber;
    }

    public MutationIdentifier registerMutation(MethodMutatorFactory factory, String description) {
        MutationIdentifier newId = this.getNextMutationIdentifer(factory, this.getJavaClassName());
        MutationDetails details = new MutationDetails(newId, this.getFileName(), description, this.lastLineNumber, this.blockCounter.getCurrentBlock(), this.blockCounter.isWithinFinallyBlock(), false);
        this.registerMutation(details);
        return newId;
    }

    public void setTargetMutation(Option<MutationIdentifier> target) {
        this.target = target;
    }

    public List<MutationDetails> getMutationDetails(MutationIdentifier id) {
        return this.mutations.filter(Context.hasId(id));
    }

    private static F<MutationDetails, Boolean> hasId(final MutationIdentifier id) {
        return new F<MutationDetails, Boolean>(){

            @Override
            public Boolean apply(MutationDetails a) {
                return a.matchesId(id);
            }
        };
    }

    public void registerClass(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void registerSourceFile(String source) {
        this.sourceFile = source;
    }

    public void registerMethod(String name, String descriptor) {
        this.location = Location.location(ClassName.fromString(this.classInfo.getName()), MethodName.fromString(name), descriptor);
        this.mutatorIndexes.clear();
    }

    public boolean shouldMutate(MutationIdentifier newId) {
        return this.getTargetMutation().contains(Context.idMatches(newId));
    }

    private static F<MutationIdentifier, Boolean> idMatches(final MutationIdentifier newId) {
        return new F<MutationIdentifier, Boolean>(){

            @Override
            public Boolean apply(MutationIdentifier a) {
                return a.matches(newId);
            }
        };
    }

    public void disableMutations(String reason) {
        this.mutationFindingDisabledReasons.add(reason);
    }

    public void enableMutatations(String reason) {
        this.mutationFindingDisabledReasons.remove(reason);
    }

    @Override
    public void registerNewBlock() {
        this.blockCounter.registerNewBlock();
    }

    @Override
    public void registerFinallyBlockStart() {
        this.blockCounter.registerFinallyBlockStart();
    }

    @Override
    public void registerFinallyBlockEnd() {
        this.blockCounter.registerFinallyBlockEnd();
    }
}

