/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pitest.bytecode.FrameOptions;
import org.pitest.bytecode.NullVisitor;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutatingClassVisitor;
import org.pitest.mutationtest.engine.gregor.PreMutationAnalyser;
import org.pitest.mutationtest.engine.gregor.PremutationClassInfo;
import org.pitest.mutationtest.engine.gregor.inlinedcode.InlinedCodeFilter;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.util.ComputeClassWriter;
import org.pitest.util.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GregorMutater
implements Mutater {
    private final Map<String, String> computeCache = new HashMap<String, String>();
    private final Predicate<MethodInfo> filter;
    private final ClassByteArraySource byteSource;
    private final Set<MethodMutatorFactory> mutators = new HashSet<MethodMutatorFactory>();
    private final Set<String> loggingClasses = new HashSet<String>();
    private final InlinedCodeFilter inlinedCodeDetector;

    public GregorMutater(ClassByteArraySource byteSource, Predicate<MethodInfo> filter, Collection<MethodMutatorFactory> mutators, Collection<String> loggingClasses, InlinedCodeFilter inlinedCodeDetector) {
        this.filter = filter;
        this.mutators.addAll(mutators);
        this.byteSource = byteSource;
        this.loggingClasses.addAll(FCollection.map(loggingClasses, Functions.classNameToJVMClassName()));
        this.inlinedCodeDetector = inlinedCodeDetector;
    }

    public FunctionalList<MutationDetails> findMutations(ClassName classToMutate) {
        Context context = new Context();
        context.setTargetMutation(Option.<MutationIdentifier>none());
        return this.byteSource.getBytes(classToMutate.asInternalName()).flatMap(this.findMutations(context));
    }

    private F<byte[], Iterable<MutationDetails>> findMutations(final Context context) {
        return new F<byte[], Iterable<MutationDetails>>(){

            @Override
            public Iterable<MutationDetails> apply(byte[] bytes) {
                return GregorMutater.this.findMutationsForBytes(context, bytes);
            }
        };
    }

    private Collection<MutationDetails> findMutationsForBytes(Context context, byte[] classToMutate) {
        PremutationClassInfo classInfo = this.performPreScan(classToMutate);
        ClassReader first = new ClassReader(classToMutate);
        NullVisitor nv = new NullVisitor();
        MutatingClassVisitor mca = new MutatingClassVisitor(nv, context, this.filterMethods(), classInfo, this.mutators);
        first.accept(mca, 8);
        return this.inlinedCodeDetector.process(context.getCollectedMutations());
    }

    private PremutationClassInfo performPreScan(byte[] classToMutate) {
        ClassReader reader = new ClassReader(classToMutate);
        PreMutationAnalyser an = new PreMutationAnalyser(this.loggingClasses);
        reader.accept(an, 0);
        return an.getClassInfo();
    }

    @Override
    public Mutant getMutation(MutationIdentifier id) {
        Context context = new Context();
        context.setTargetMutation(Option.some(id));
        Option<byte[]> bytes = this.byteSource.getBytes(id.getClassName().asJavaName());
        PremutationClassInfo classInfo = this.performPreScan(bytes.value());
        ClassReader reader = new ClassReader(bytes.value());
        ComputeClassWriter w = new ComputeClassWriter(this.byteSource, this.computeCache, FrameOptions.pickFlags(bytes.value()));
        MutatingClassVisitor mca = new MutatingClassVisitor(w, context, this.filterMethods(), classInfo, FCollection.filter(this.mutators, GregorMutater.isMutatorFor(id)));
        reader.accept(mca, 8);
        List<MutationDetails> details = context.getMutationDetails(context.getTargetMutation().value());
        return new Mutant(details.get(0), w.toByteArray());
    }

    private static Predicate<MethodMutatorFactory> isMutatorFor(final MutationIdentifier id) {
        return new Predicate<MethodMutatorFactory>(){

            @Override
            public Boolean apply(MethodMutatorFactory a) {
                return id.getMutator().equals(a.getGloballyUniqueId());
            }
        };
    }

    private Predicate<MethodInfo> filterMethods() {
        return Prelude.and(this.filter, GregorMutater.filterSyntheticMethods(), Prelude.not(GregorMutater.isGeneratedEnumMethod()), Prelude.not(GregorMutater.isGroovyClass()));
    }

    private static F<MethodInfo, Boolean> isGroovyClass() {
        return new Predicate<MethodInfo>(){

            @Override
            public Boolean apply(MethodInfo a) {
                return a.isInGroovyClass();
            }
        };
    }

    private static Predicate<MethodInfo> filterSyntheticMethods() {
        return new Predicate<MethodInfo>(){

            @Override
            public Boolean apply(MethodInfo a) {
                return !a.isSynthetic() || a.getName().startsWith("lambda$");
            }
        };
    }

    private static Predicate<MethodInfo> isGeneratedEnumMethod() {
        return new Predicate<MethodInfo>(){

            @Override
            public Boolean apply(MethodInfo a) {
                return a.isGeneratedEnumMethod();
            }
        };
    }
}

