/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.engine.gregor.GregorMutater;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationEngineConfiguration;
import org.pitest.mutationtest.engine.gregor.inlinedcode.InlinedCodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GregorMutationEngine
implements MutationEngine {
    private final Set<MethodMutatorFactory> mutationOperators = new LinkedHashSet<MethodMutatorFactory>();
    private final Set<String> loggingClasses = new LinkedHashSet<String>();
    private final Predicate<MethodInfo> methodFilter;
    private final InlinedCodeFilter inlinedCodeDetector;

    public GregorMutationEngine(MutationEngineConfiguration config) {
        this.methodFilter = config.methodFilter();
        this.mutationOperators.addAll(config.mutators());
        this.loggingClasses.addAll(config.doNotMutateCallsTo());
        this.inlinedCodeDetector = config.inlinedCodeDetector();
    }

    @Override
    public Mutater createMutator(ClassByteArraySource byteSource) {
        return new GregorMutater(byteSource, this.methodFilter, this.mutationOperators, this.loggingClasses, this.inlinedCodeDetector);
    }

    public String toString() {
        return "GregorMutationEngine [filter=" + this.methodFilter + ", mutationOperators=" + this.mutationOperators + "]";
    }

    @Override
    public Collection<String> getMutatorNames() {
        return FCollection.map(this.mutationOperators, GregorMutationEngine.toName());
    }

    private static F<MethodMutatorFactory, String> toName() {
        return new F<MethodMutatorFactory, String>(){

            @Override
            public String apply(MethodMutatorFactory a) {
                return a.getName();
            }
        };
    }
}

