/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pitest.functional.F;
import org.pitest.mutationtest.engine.gregor.AvoidAssertsMethodAdapter;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.LineFilterMethodAdapter;
import org.pitest.mutationtest.engine.gregor.LineTrackingMethodVisitor;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.PremutationClassInfo;
import org.pitest.mutationtest.engine.gregor.blocks.BlockTrackingMethodDecorator;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MutatingClassVisitor
extends ClassVisitor {
    private final F<MethodInfo, Boolean> filter;
    private final Context context;
    private final Set<MethodMutatorFactory> methodMutators = new HashSet<MethodMutatorFactory>();
    private final PremutationClassInfo classInfo;

    public MutatingClassVisitor(ClassVisitor delegateClassVisitor, Context context, F<MethodInfo, Boolean> filter, PremutationClassInfo classInfo, Collection<MethodMutatorFactory> mutators) {
        super(327680, delegateClassVisitor);
        this.context = context;
        this.filter = filter;
        this.methodMutators.addAll(mutators);
        this.classInfo = classInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.context.registerClass(new ClassInfo(version, access, name, signature, superName, interfaces));
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.context.registerSourceFile(source);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String signature, String[] exceptions) {
        this.context.registerMethod(methodName, methodDescriptor);
        MethodVisitor methodVisitor = this.cv.visitMethod(access, methodName, methodDescriptor, signature, exceptions);
        MethodInfo info = new MethodInfo().withOwner(this.context.getClassInfo()).withAccess(access).withMethodName(methodName).withMethodDescriptor(methodDescriptor);
        if (this.filter.apply(info).booleanValue()) {
            return this.visitMethodForMutation(info, methodVisitor);
        }
        return methodVisitor;
    }

    private MethodVisitor visitMethodForMutation(MethodInfo methodInfo, MethodVisitor methodVisitor) {
        MethodVisitor next = methodVisitor;
        for (MethodMutatorFactory each : this.methodMutators) {
            next = each.create(this.context, methodInfo, next);
        }
        return this.wrapWithDecorators(this.wrapWithFilters(next));
    }

    private MethodVisitor wrapWithDecorators(MethodVisitor mv) {
        return this.wrapWithBlockTracker(this.wrapWithLineTracker(mv));
    }

    private MethodVisitor wrapWithBlockTracker(MethodVisitor mv) {
        return new BlockTrackingMethodDecorator(this.context, mv);
    }

    private MethodVisitor wrapWithLineTracker(MethodVisitor mv) {
        return new LineTrackingMethodVisitor(this.context, mv);
    }

    private MethodVisitor wrapWithFilters(MethodVisitor wrappedMethodVisitor) {
        return this.wrapWithLineFilter(this.wrapWithAssertFilter(wrappedMethodVisitor));
    }

    private MethodVisitor wrapWithAssertFilter(MethodVisitor wrappedMethodVisitor) {
        return new AvoidAssertsMethodAdapter(this.context, wrappedMethodVisitor);
    }

    private MethodVisitor wrapWithLineFilter(MethodVisitor wrappedMethodVisitor) {
        return new LineFilterMethodAdapter(this.context, this.classInfo, wrappedMethodVisitor);
    }
}

