/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Set;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.engine.gregor.PremutationClassInfo;
import org.pitest.mutationtest.engine.gregor.TryWithResourcesMethodVisitor;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreMutationMethodAnalyzer
extends MethodVisitor {
    private final Set<String> loggingClasses;
    private int currentLineNumber;
    private final PremutationClassInfo classInfo;

    public PreMutationMethodAnalyzer(Set<String> loggingClasses, PremutationClassInfo classInfo) {
        super(327680, new TryWithResourcesMethodVisitor(classInfo));
        this.classInfo = classInfo;
        this.loggingClasses = loggingClasses;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (FCollection.contains(this.loggingClasses, PreMutationMethodAnalyzer.matches(owner))) {
            this.classInfo.registerLineToAvoid(this.currentLineNumber);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private static F<String, Boolean> matches(final String owner) {
        return new F<String, Boolean>(){

            @Override
            public Boolean apply(String a) {
                return owner.startsWith(a);
            }
        };
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.currentLineNumber = line;
        super.visitLineNumber(line, start);
    }
}

