/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.config;

import java.util.Collection;
import org.pitest.functional.F;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.engine.gregor.GregorMutationEngine;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.config.DefaultMutationEngineConfiguration;
import org.pitest.mutationtest.engine.gregor.config.Mutator;
import org.pitest.mutationtest.engine.gregor.inlinedcode.InlinedCodeFilter;
import org.pitest.mutationtest.engine.gregor.inlinedcode.InlinedFinallyBlockDetector;
import org.pitest.mutationtest.engine.gregor.inlinedcode.NoInlinedCodeDetection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GregorEngineFactory
implements MutationEngineFactory {
    @Override
    public MutationEngine createEngine(boolean mutateStaticInitializers, Predicate<String> excludedMethods, Collection<String> loggingClasses, Collection<String> mutators, boolean detectInlinedCode) {
        return this.createEngineWithMutators(mutateStaticInitializers, excludedMethods, loggingClasses, GregorEngineFactory.createMutatorListFromArrayOrUseDefaults(mutators), detectInlinedCode);
    }

    public MutationEngine createEngineWithMutators(boolean mutateStaticInitializers, Predicate<String> excludedMethods, Collection<String> loggingClasses, Collection<? extends MethodMutatorFactory> mutators, boolean detectInlinedCode) {
        Predicate<MethodInfo> filter = GregorEngineFactory.pickFilter(mutateStaticInitializers, Prelude.not(GregorEngineFactory.stringToMethodInfoPredicate(excludedMethods)));
        DefaultMutationEngineConfiguration config = new DefaultMutationEngineConfiguration(filter, loggingClasses, mutators, GregorEngineFactory.inlinedCodeDetector(detectInlinedCode));
        return new GregorMutationEngine(config);
    }

    private static InlinedCodeFilter inlinedCodeDetector(boolean detectInlinedCode) {
        if (detectInlinedCode) {
            return new InlinedFinallyBlockDetector();
        }
        return new NoInlinedCodeDetection();
    }

    private static Collection<? extends MethodMutatorFactory> createMutatorListFromArrayOrUseDefaults(Collection<String> mutators) {
        if (mutators != null && !mutators.isEmpty()) {
            return Mutator.fromStrings(mutators);
        }
        return Mutator.defaults();
    }

    private static Predicate<MethodInfo> pickFilter(boolean mutateStaticInitializers, Predicate<MethodInfo> excludedMethods) {
        if (!mutateStaticInitializers) {
            return Prelude.and(excludedMethods, GregorEngineFactory.notStaticInitializer());
        }
        return excludedMethods;
    }

    private static F<MethodInfo, Boolean> stringToMethodInfoPredicate(final Predicate<String> excludedMethods) {
        return new Predicate<MethodInfo>(){

            @Override
            public Boolean apply(MethodInfo a) {
                return (Boolean)excludedMethods.apply(a.getName());
            }
        };
    }

    private static Predicate<MethodInfo> notStaticInitializer() {
        return new Predicate<MethodInfo>(){

            @Override
            public Boolean apply(MethodInfo a) {
                return !a.isStaticInitializer();
            }
        };
    }

    @Override
    public String name() {
        return "gregor";
    }

    @Override
    public String description() {
        return "Default mutation engine";
    }
}

