/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.mutators.ConditionalsBoundaryMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ConstructorCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.IncrementsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.InlineConstantMutator;
import org.pitest.mutationtest.engine.gregor.mutators.InvertNegsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.MathMutator;
import org.pitest.mutationtest.engine.gregor.mutators.NegateConditionalsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.NonVoidMethodCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.VoidMethodCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.MemberVariableMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.RemoveIncrementsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.RemoveSwitchMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.SwitchMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mutator {
    private static final Map<String, Iterable<MethodMutatorFactory>> mutators = new LinkedHashMap<String, Iterable<MethodMutatorFactory>>();

    public static Collection<MethodMutatorFactory> all() {
        return Mutator.fromStrings(mutators.keySet());
    }

    private static Collection<MethodMutatorFactory> stronger() {
        return Mutator.combine(Mutator.defaults(), Mutator.group(new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, false), new SwitchMutator()));
    }

    private static Collection<MethodMutatorFactory> combine(Collection<MethodMutatorFactory> a, Collection<MethodMutatorFactory> b) {
        ArrayList<MethodMutatorFactory> l = new ArrayList<MethodMutatorFactory>(a);
        l.addAll(b);
        return l;
    }

    public static Collection<MethodMutatorFactory> defaults() {
        return Mutator.group(InvertNegsMutator.INVERT_NEGS_MUTATOR, ReturnValsMutator.RETURN_VALS_MUTATOR, MathMutator.MATH_MUTATOR, VoidMethodCallMutator.VOID_METHOD_CALL_MUTATOR, NegateConditionalsMutator.NEGATE_CONDITIONALS_MUTATOR, ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY_MUTATOR, IncrementsMutator.INCREMENTS_MUTATOR);
    }

    private static Collection<MethodMutatorFactory> group(MethodMutatorFactory ... ms) {
        return Arrays.asList(ms);
    }

    public static Collection<MethodMutatorFactory> byName(String name) {
        return FCollection.map(mutators.get(name), Prelude.id(MethodMutatorFactory.class));
    }

    private static void add(String key, MethodMutatorFactory value) {
        mutators.put(key, Collections.singleton(value));
    }

    private static void addGroup(String key, Iterable<MethodMutatorFactory> value) {
        mutators.put(key, value);
    }

    public static Collection<MethodMutatorFactory> fromStrings(Collection<String> names) {
        TreeSet<MethodMutatorFactory> unique = new TreeSet<MethodMutatorFactory>(Mutator.compareId());
        FCollection.flatMapTo(names, Mutator.fromString(), unique);
        return unique;
    }

    private static Comparator<? super MethodMutatorFactory> compareId() {
        return new Comparator<MethodMutatorFactory>(){

            @Override
            public int compare(MethodMutatorFactory o1, MethodMutatorFactory o2) {
                return o1.getGloballyUniqueId().compareTo(o2.getGloballyUniqueId());
            }
        };
    }

    private static F<String, Iterable<MethodMutatorFactory>> fromString() {
        return new F<String, Iterable<MethodMutatorFactory>>(){

            @Override
            public Iterable<MethodMutatorFactory> apply(String a) {
                return (Iterable)mutators.get(a);
            }
        };
    }

    static {
        Mutator.add("INVERT_NEGS", InvertNegsMutator.INVERT_NEGS_MUTATOR);
        Mutator.add("RETURN_VALS", ReturnValsMutator.RETURN_VALS_MUTATOR);
        Mutator.add("INLINE_CONSTS", new InlineConstantMutator());
        Mutator.add("MATH", MathMutator.MATH_MUTATOR);
        Mutator.add("VOID_METHOD_CALLS", VoidMethodCallMutator.VOID_METHOD_CALL_MUTATOR);
        Mutator.add("NEGATE_CONDITIONALS", NegateConditionalsMutator.NEGATE_CONDITIONALS_MUTATOR);
        Mutator.add("CONDITIONALS_BOUNDARY", ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY_MUTATOR);
        Mutator.add("INCREMENTS", IncrementsMutator.INCREMENTS_MUTATOR);
        Mutator.add("REMOVE_INCREMENTS", RemoveIncrementsMutator.REMOVE_INCREMENTS_MUTATOR);
        Mutator.add("NON_VOID_METHOD_CALLS", NonVoidMethodCallMutator.NON_VOID_METHOD_CALL_MUTATOR);
        Mutator.add("CONSTRUCTOR_CALLS", ConstructorCallMutator.CONSTRUCTOR_CALL_MUTATOR);
        Mutator.add("REMOVE_CONDITIONALS_EQ_IF", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, true));
        Mutator.add("REMOVE_CONDITIONALS_EQ_ELSE", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, false));
        Mutator.add("REMOVE_CONDITIONALS_ORD_IF", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.ORDER, true));
        Mutator.add("REMOVE_CONDITIONALS_ORD_ELSE", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.ORDER, false));
        Mutator.addGroup("REMOVE_CONDITIONALS", RemoveConditionalMutator.makeMutators());
        Mutator.add("EXPERIMENTAL_MEMBER_VARIABLE", new MemberVariableMutator());
        Mutator.add("EXPERIMENTAL_SWITCH", new SwitchMutator());
        Mutator.addGroup("REMOVE_SWITCH", RemoveSwitchMutator.makeMutators());
        Mutator.addGroup("DEFAULTS", Mutator.defaults());
        Mutator.addGroup("STRONGER", Mutator.stronger());
        Mutator.addGroup("ALL", Mutator.all());
    }
}

