/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.inlinedcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.inlinedcode.InlinedCodeFilter;
import org.pitest.mutationtest.engine.gregor.inlinedcode.LineMutatorPair;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlinedFinallyBlockDetector
implements InlinedCodeFilter {
    private static final Logger LOG = Log.getLogger();

    @Override
    public Collection<MutationDetails> process(Collection<MutationDetails> mutations) {
        ArrayList<MutationDetails> combined = new ArrayList<MutationDetails>(mutations.size());
        Map<LineMutatorPair, Collection<MutationDetails>> mutatorLinebuckets = FCollection.bucket(mutations, InlinedFinallyBlockDetector.toLineMutatorPair());
        for (Map.Entry<LineMutatorPair, Collection<MutationDetails>> each : mutatorLinebuckets.entrySet()) {
            if (each.getValue().size() > 1) {
                this.checkForInlinedCode(combined, each);
                continue;
            }
            combined.addAll(each.getValue());
        }
        Collections.sort(combined, InlinedFinallyBlockDetector.compareLineNumbers());
        return combined;
    }

    private static Comparator<MutationDetails> compareLineNumbers() {
        return new Comparator<MutationDetails>(){

            @Override
            public int compare(MutationDetails arg0, MutationDetails arg1) {
                return arg0.getLineNumber() - arg1.getLineNumber();
            }
        };
    }

    private void checkForInlinedCode(Collection<MutationDetails> combined, Map.Entry<LineMutatorPair, Collection<MutationDetails>> each) {
        FunctionalList<MutationDetails> mutationsInHandlerBlock = FCollection.filter((Iterable)each.getValue(), InlinedFinallyBlockDetector.isInFinallyHandler());
        if (!this.isPossibleToCorrectInlining(mutationsInHandlerBlock)) {
            combined.addAll(each.getValue());
            return;
        }
        MutationDetails baseMutation = (MutationDetails)mutationsInHandlerBlock.get(0);
        int firstBlock = baseMutation.getBlock();
        FunctionalList<Integer> ids = FCollection.map((Iterable)each.getValue(), InlinedFinallyBlockDetector.mutationToBlock());
        if (ids.contains(Prelude.not(Prelude.isEqualTo(firstBlock)))) {
            combined.add(InlinedFinallyBlockDetector.makeCombinedMutant(each.getValue()));
        } else {
            combined.addAll(each.getValue());
        }
    }

    private boolean isPossibleToCorrectInlining(List<MutationDetails> mutationsInHandlerBlock) {
        if (mutationsInHandlerBlock.size() > 1) {
            LOG.warning("Found more than one mutation similar on same line in a finally block. Can't correct for inlining.");
            return false;
        }
        return !mutationsInHandlerBlock.isEmpty();
    }

    private static F<MutationDetails, Boolean> isInFinallyHandler() {
        return new F<MutationDetails, Boolean>(){

            @Override
            public Boolean apply(MutationDetails a) {
                return a.isInFinallyBlock();
            }
        };
    }

    private static MutationDetails makeCombinedMutant(Collection<MutationDetails> value) {
        MutationDetails first = value.iterator().next();
        HashSet<Integer> indexes = new HashSet<Integer>();
        FCollection.mapTo(value, InlinedFinallyBlockDetector.mutationToIndex(), indexes);
        MutationIdentifier id = new MutationIdentifier(first.getId().getLocation(), indexes, first.getId().getMutator());
        return new MutationDetails(id, first.getFilename(), first.getDescription(), first.getLineNumber(), first.getBlock());
    }

    private static F<MutationDetails, Integer> mutationToIndex() {
        return new F<MutationDetails, Integer>(){

            @Override
            public Integer apply(MutationDetails a) {
                return a.getFirstIndex();
            }
        };
    }

    private static F<MutationDetails, Integer> mutationToBlock() {
        return new F<MutationDetails, Integer>(){

            @Override
            public Integer apply(MutationDetails a) {
                return a.getBlock();
            }
        };
    }

    private static F<MutationDetails, LineMutatorPair> toLineMutatorPair() {
        return new F<MutationDetails, LineMutatorPair>(){

            @Override
            public LineMutatorPair apply(MutationDetails a) {
                return new LineMutatorPair(a.getLineNumber(), a.getMutator());
            }
        };
    }
}

