/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.util.PitError;

public class InlineConstantMutator
implements MethodMutatorFactory {
    public MethodVisitor create(Context context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new InlineConstantVisitor(context, methodVisitor);
    }

    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    public String toString() {
        return "INLINE_CONSTANT_MUTATOR";
    }

    public String getName() {
        return this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InlineConstantVisitor
    extends MethodVisitor {
        private final Context context;

        public InlineConstantVisitor(Context context, MethodVisitor delegateVisitor) {
            super(327680, delegateVisitor);
            this.context = context;
        }

        private void mutate(Double constant) {
            Double replacement = constant == 1.0 ? 2.0 : 1.0;
            if (this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        private void mutate(Float constant) {
            Float replacement = Float.valueOf(constant.floatValue() == 1.0f ? 2.0f : 1.0f);
            if (this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        private void mutate(Integer constant) {
            Integer replacement;
            switch (constant) {
                case 1: {
                    replacement = 0;
                    break;
                }
                case 127: {
                    replacement = -128;
                    break;
                }
                case 32767: {
                    replacement = Short.MIN_VALUE;
                    break;
                }
                default: {
                    replacement = constant + 1;
                }
            }
            if (this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        private void mutate(Long constant) {
            Long replacement = constant + 1L;
            if (this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        private void mutate(Number constant) {
            if (constant instanceof Integer) {
                this.mutate((Integer)constant);
            } else if (constant instanceof Long) {
                this.mutate((Long)constant);
            } else if (constant instanceof Float) {
                this.mutate((Float)constant);
            } else if (constant instanceof Double) {
                this.mutate((Double)constant);
            } else {
                throw new PitError("Unsupported subtype of Number found:" + constant.getClass());
            }
        }

        private <T extends Number> boolean shouldMutate(T constant, T replacement) {
            MutationIdentifier mutationId = this.context.registerMutation(InlineConstantMutator.this, "Substituted " + constant + " with " + replacement);
            return this.context.shouldMutate(mutationId);
        }

        private void translateToByteCode(Double constant) {
            if (constant == 0.0) {
                super.visitInsn(14);
            } else if (constant == 1.0) {
                super.visitInsn(15);
            } else {
                super.visitLdcInsn(constant);
            }
        }

        private void translateToByteCode(Float constant) {
            if (constant.floatValue() == 0.0f) {
                super.visitInsn(11);
            } else if (constant.floatValue() == 1.0f) {
                super.visitInsn(12);
            } else if (constant.floatValue() == 2.0f) {
                super.visitInsn(13);
            } else {
                super.visitLdcInsn(constant);
            }
        }

        private void translateToByteCode(Integer constant) {
            switch (constant) {
                case -1: {
                    super.visitInsn(2);
                    break;
                }
                case 0: {
                    super.visitInsn(3);
                    break;
                }
                case 1: {
                    super.visitInsn(4);
                    break;
                }
                case 2: {
                    super.visitInsn(5);
                    break;
                }
                case 3: {
                    super.visitInsn(6);
                    break;
                }
                case 4: {
                    super.visitInsn(7);
                    break;
                }
                case 5: {
                    super.visitInsn(8);
                    break;
                }
                default: {
                    super.visitLdcInsn(constant);
                }
            }
        }

        private void translateToByteCode(Long constant) {
            if (constant == 0L) {
                super.visitInsn(9);
            } else if (constant == 1L) {
                super.visitInsn(10);
            } else {
                super.visitLdcInsn(constant);
            }
        }

        private Number translateToNumber(int opcode) {
            switch (opcode) {
                case 2: {
                    return -1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 4;
                }
                case 8: {
                    return 5;
                }
                case 9: {
                    return 0L;
                }
                case 10: {
                    return 1L;
                }
                case 11: {
                    return Float.valueOf(0.0f);
                }
                case 12: {
                    return Float.valueOf(1.0f);
                }
                case 13: {
                    return Float.valueOf(2.0f);
                }
                case 14: {
                    return 0.0;
                }
                case 15: {
                    return 1.0;
                }
            }
            return null;
        }

        @Override
        public void visitInsn(int opcode) {
            Number inlineConstant = this.translateToNumber(opcode);
            if (inlineConstant == null) {
                super.visitInsn(opcode);
                return;
            }
            this.mutate(inlineConstant);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 || opcode == 17) {
                this.mutate(operand);
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }

        @Override
        public void visitLdcInsn(Object constant) {
            if (constant instanceof Number) {
                this.mutate((Number)constant);
            } else {
                super.visitLdcInsn(constant);
            }
        }
    }
}

