/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.HashMap;
import java.util.Map;
import org.pitest.functional.F2;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCallMethodVisitor
extends MethodVisitor {
    private static final Map<Type, Integer> RETURN_TYPE_MAP = new HashMap<Type, Integer>();
    private final F2<String, String, Boolean> filter;
    private final MethodMutatorFactory factory;
    private final Context context;
    private final MethodInfo methodInfo;

    public MethodCallMethodVisitor(MethodInfo methodInfo, Context context, MethodVisitor writer, MethodMutatorFactory factory, F2<String, String, Boolean> filter) {
        super(327680, writer);
        this.factory = factory;
        this.filter = filter;
        this.context = context;
        this.methodInfo = methodInfo;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.filter.apply(name, desc).booleanValue() || this.isCallToSuperOrOwnConstructor(name, owner)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        } else {
            MutationIdentifier newId = this.context.registerMutation(this.factory, "removed call to " + owner + "::" + name);
            if (this.context.shouldMutate(newId)) {
                this.popStack(desc, name);
                this.popThisIfNotStatic(opcode);
                this.putReturnValueOnStack(desc, name);
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private boolean isCallToSuperOrOwnConstructor(String name, String owner) {
        return this.methodInfo.isConstructor() && MethodInfo.isConstructor(name) && (owner.equals(this.context.getClassInfo().getName()) || this.context.getClassInfo().getSuperName().equals(owner));
    }

    private void popThisIfNotStatic(int opcode) {
        if (!MethodCallMethodVisitor.isStatic(opcode)) {
            this.mv.visitInsn(87);
        }
    }

    private void popStack(String desc, String name) {
        Type[] argTypes = Type.getArgumentTypes(desc);
        for (int i = argTypes.length - 1; i >= 0; --i) {
            Type argumentType = argTypes[i];
            if (argumentType.getSize() != 1) {
                this.mv.visitInsn(88);
                continue;
            }
            this.mv.visitInsn(87);
        }
        if (MethodInfo.isConstructor(name)) {
            this.mv.visitInsn(87);
        }
    }

    private static boolean isStatic(int opcode) {
        return 184 == opcode;
    }

    private void putReturnValueOnStack(String desc, String name) {
        Type returnType = Type.getReturnType(desc);
        if (!returnType.equals(Type.VOID_TYPE)) {
            Integer opCode = RETURN_TYPE_MAP.get(returnType);
            if (opCode == null) {
                this.mv.visitInsn(1);
            } else {
                this.mv.visitInsn(opCode);
            }
        } else if (MethodInfo.isConstructor(name)) {
            this.mv.visitInsn(1);
        }
    }

    static {
        RETURN_TYPE_MAP.put(Type.INT_TYPE, 3);
        RETURN_TYPE_MAP.put(Type.BOOLEAN_TYPE, 3);
        RETURN_TYPE_MAP.put(Type.BYTE_TYPE, 3);
        RETURN_TYPE_MAP.put(Type.CHAR_TYPE, 3);
        RETURN_TYPE_MAP.put(Type.SHORT_TYPE, 3);
        RETURN_TYPE_MAP.put(Type.LONG_TYPE, 9);
        RETURN_TYPE_MAP.put(Type.FLOAT_TYPE, 11);
        RETURN_TYPE_MAP.put(Type.DOUBLE_TYPE, 14);
    }
}

