/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.ArrayList;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveConditionalMutator
implements MethodMutatorFactory {
    private final Choice kind;
    private final boolean replaceWith;

    public RemoveConditionalMutator(Choice c, boolean rc) {
        this.kind = c;
        this.replaceWith = rc;
    }

    public static Iterable<MethodMutatorFactory> makeMutators() {
        ArrayList<MethodMutatorFactory> variations = new ArrayList<MethodMutatorFactory>();
        Choice[] allChoices = new Choice[]{Choice.EQUAL, Choice.ORDER};
        boolean[] arrWith = new boolean[]{true, false};
        for (Choice c : allChoices) {
            for (boolean b : arrWith) {
                variations.add(new RemoveConditionalMutator(c, b));
            }
        }
        return variations;
    }

    @Override
    public MethodVisitor create(Context context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new RemoveConditionalMethodVisitor(this, context, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName() + "_" + (Object)((Object)this.kind) + "_" + (this.replaceWith ? "IF" : "ELSE");
    }

    @Override
    public String getName() {
        return "REMOVE_CONDITIONALS_" + (Object)((Object)this.kind) + "_" + (this.replaceWith ? "IF" : "ELSE") + "_MUTATOR";
    }

    private final class RemoveConditionalMethodVisitor
    extends MethodVisitor {
        private static final String DESCRIPTION = "removed conditional";
        private final Context context;
        private final MethodMutatorFactory factory;

        public RemoveConditionalMethodVisitor(MethodMutatorFactory factory, Context context, MethodVisitor delegateMethodVisitor) {
            super(327680, delegateMethodVisitor);
            this.context = context;
            this.factory = factory;
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (this.canMutate(opcode)) {
                MutationIdentifier newId = this.context.registerMutation(this.factory, DESCRIPTION);
                if (this.context.shouldMutate(newId)) {
                    this.emptyStack(opcode);
                    if (!RemoveConditionalMutator.this.replaceWith) {
                        super.visitJumpInsn(167, label);
                    }
                } else {
                    this.mv.visitJumpInsn(opcode, label);
                }
            } else {
                this.mv.visitJumpInsn(opcode, label);
            }
        }

        private void emptyStack(int opcode) {
            switch (opcode) {
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    super.visitInsn(88);
                    break;
                }
                default: {
                    super.visitInsn(87);
                }
            }
        }

        private boolean canMutate(int opcode) {
            switch (opcode) {
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    return RemoveConditionalMutator.this.kind == Choice.ORDER;
                }
                case 153: 
                case 154: 
                case 159: 
                case 160: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    return RemoveConditionalMutator.this.kind == Choice.EQUAL;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Choice {
        EQUAL,
        ORDER;

    }
}

